/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.modules;

import com.yogpc.qp.machines.base.APowerTile;
import com.yogpc.qp.machines.base.IDisabled;
import com.yogpc.qp.machines.base.IModule;
import com.yogpc.qp.machines.base.QPItem;
import com.yogpc.qp.machines.exppump.ExpPumpModule;
import com.yogpc.qp.machines.modules.IModuleItem;
import com.yogpc.qp.machines.quarry.ContainerQuarryModule;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import scala.Function1;
import scala.Symbol;

public class ItemExpPumpModule
extends QPItem
implements IDisabled,
IModuleItem {
    public static final String Key_xp = "xp";

    public ItemExpPumpModule() {
        super("exppump_module", (Function1<Item.Properties, Item.Properties>)((Function1)p -> p.func_208103_a(Rarity.UNCOMMON)));
    }

    @Override
    public Symbol getSymbol() {
        return Symbol.apply((String)"ModuleExpPump");
    }

    @Override
    public <T extends APowerTile & ContainerQuarryModule.HasModuleInventory> Function<T, IModule> getModule(ItemStack stack) {
        int xp = this.getXPInStack(stack).orElse(0);
        return t -> {
            ExpPumpModule module = ExpPumpModule.fromTile(t, value -> stack.func_77983_a(Key_xp, NBTDynamicOps.field_210820_a.createInt(value)));
            module.xp_$eq(xp);
            return module;
        };
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.getXPInStack(stack).ifPresent(integer -> tooltip.add((ITextComponent)new StringTextComponent("xp: " + integer)));
    }

    private Optional<Integer> getXPInStack(ItemStack stack) {
        return Optional.ofNullable(stack.func_77978_p()).map(tag -> tag.func_74781_a(Key_xp)).flatMap(t -> NBTDynamicOps.field_210820_a.getNumberValue(t).result()).map(Number::intValue);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack;
        int xp;
        if (!playerIn.func_213453_ef() && (xp = this.getXPInStack(stack = playerIn.func_184586_b(handIn)).orElse(0).intValue()) > 0) {
            stack.func_196083_e(Key_xp);
            if (!worldIn.field_72995_K) {
                Vector3d vec = playerIn.func_213303_ch();
                ExperienceOrbEntity orb = new ExperienceOrbEntity(worldIn, vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c(), xp);
                worldIn.func_217376_c((Entity)orb);
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }
}

