/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.machines.base.IEnchantableTile;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryItem;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryTile;
import com.yogpc.qp.utils.Holder;
import java.util.Optional;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class MiniQuarryBlock
extends QPBlock {
    public MiniQuarryBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d), "mini_quarry", MiniQuarryItem::new);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH)).func_206870_a((Property)QPBlock.WORKING(), (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public TileEntityType<? extends TileEntity> getTileType() {
        return Holder.miniQuarryType();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H, QPBlock.WORKING()});
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (super.func_225533_a_(state, worldIn, pos, player, hand, hit).func_226247_b_()) {
            return ActionResultType.SUCCESS;
        }
        if (!player.func_213453_ef()) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable(worldIn.func_175625_s(pos)).flatMap(MapStreamSyntax.optCast(MiniQuarryTile.class)).ifPresent(t -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)t, (BlockPos)pos));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            if (placer != null) {
                Direction facing = placer.func_174811_aO().func_176734_d();
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)facing), 2);
            }
            Optional.ofNullable(worldIn.func_175625_s(pos)).flatMap(MapStreamSyntax.optCast(MiniQuarryTile.class)).ifPresent(t -> {
                IEnchantableTile.Util.init(t, stack.func_77986_q());
                MiniQuarryTile.requestTicket.accept(t);
            });
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (!worldIn.field_72995_K) {
            boolean powered = worldIn.func_175640_z(pos);
            Optional.ofNullable(worldIn.func_175625_s(pos)).flatMap(MapStreamSyntax.optCast(MiniQuarryTile.class)).ifPresent(t -> {
                if (powered && !t.rs()) {
                    t.gotRSPulse();
                }
                t.rs_$eq(powered);
            });
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity entity = worldIn.func_175625_s(pos);
            if (entity instanceof MiniQuarryTile) {
                MiniQuarryTile tile = (MiniQuarryTile)entity;
                InvUtils.dropAndUpdateInv(worldIn, pos, tile.getInv(), (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }
}

