/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.bookmover;

import com.yogpc.qp.machines.base.SlotTile;
import com.yogpc.qp.machines.bookmover.TileBookMover;
import com.yogpc.qp.utils.Holder;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerBookMover
extends Container {
    private final TileBookMover mover;
    private final IntReferenceHolder progress = this.func_216958_a(IntReferenceHolder.func_221492_a());
    private final IntReferenceHolder isWorking = this.func_216958_a(IntReferenceHolder.func_221492_a());

    public ContainerBookMover(int id, PlayerEntity player, BlockPos pos) {
        super(Holder.bookMoverContainerType(), id);
        this.mover = (TileBookMover)player.func_130014_f_().func_175625_s(pos);
        if (this.mover != null) {
            this.func_75146_a(new SlotTile(this.mover, 0, 13, 35));
            this.func_75146_a(new SlotTile(this.mover, 1, 55, 35));
            this.func_75146_a(new SlotTile(this.mover, 2, 116, 35));
            if (!player.func_130014_f_().field_72995_K) {
                this.progress.func_221494_a((int)(this.mover.getStoredEnergy() / this.mover.getMaxStored() * 1000L));
                this.isWorking.func_221494_a(this.mover.isWorking() ? 1 : 0);
            }
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, k, 8 + k * 18, 142));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.mover.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        int allSlots = 3;
        ItemStack src = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack remain = slot.func_75211_c();
            src = remain.func_77946_l();
            if (index < allSlots) {
                if (!this.func_75135_a(remain, allSlots, allSlots + 36, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                for (int i = 0; i < allSlots; ++i) {
                    if (!this.mover.func_94041_b(i, remain)) continue;
                    if (this.func_75135_a(remain, i, i + 1, false)) break;
                    return ItemStack.field_190927_a;
                }
            }
            if (remain.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (remain.func_190916_E() == src.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, remain);
        }
        return src;
    }

    public void func_75142_b() {
        int progress = (int)(1000L * this.mover.getStoredEnergy() / this.mover.getMaxStored());
        this.progress.func_221494_a(progress);
        this.isWorking.func_221494_a(this.mover.isWorking() ? 1 : 0);
        super.func_75142_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgress() {
        return this.progress.func_221495_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean moverIsWorking() {
        return this.isWorking.func_221495_b() == 1;
    }
}

