/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration.ftbchunks;

import com.yogpc.qp.Config;
import com.yogpc.qp.integration.ftbchunks.ManagerNew;
import com.yogpc.qp.integration.ftbchunks.ManagerOld;
import com.yogpc.qp.machines.base.Area;
import com.yogpc.qp.machines.base.IRemotePowerOn;
import com.yogpc.qp.machines.quarry.QuarryFakePlayer;
import com.yogpc.qp.machines.quarry.TileMiningWell;
import com.yogpc.qp.machines.quarry.TileQuarry;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Option;

public class QuarryChunkProtectionManager {
    private static final String CHUNK_MOD_ID = "ftbchunks";
    private static final AtomicInteger IS_LOADED = new AtomicInteger(-1);
    private static final AtomicInteger IS_OLD = new AtomicInteger(-1);
    private static final AtomicInteger IS_NEW = new AtomicInteger(-1);
    private static final String MESSAGE = "Quarry found protected chunks in the area. Please add [QuarryPlus] as your ally or allow fake players to interact this area.";
    private static final Logger LOGGER = LogManager.getLogger();

    private static boolean hasProtectionMod() {
        int pre = IS_LOADED.get();
        if (pre == -1) {
            IS_LOADED.set(QuarryChunkProtectionManager.isModLoaded() ? 1 : 0);
            return IS_LOADED.get() == 1;
        }
        return pre == 1;
    }

    private static boolean isModLoaded() {
        if (ModList.get().isLoaded(CHUNK_MOD_ID)) {
            try {
                return (Boolean)Config.common().sendNotificationOfChunkProtection().get();
            }
            catch (Exception ignore) {
                return true;
            }
        }
        return false;
    }

    private static boolean isOld() {
        if (IS_OLD.get() == -1) {
            try {
                Class.forName("com.feed_the_beast.mods.ftbchunks.api.FTBChunksAPI");
                IS_OLD.set(1);
            }
            catch (Exception ignore) {
                IS_OLD.set(0);
            }
        }
        return IS_OLD.get() == 1;
    }

    private static boolean isNew() {
        if (IS_NEW.get() == -1) {
            try {
                Class.forName("com.feed_the_beast.mods.ftbchunks.api.FTBChunksAPI");
                IS_NEW.set(1);
            }
            catch (Exception ignore) {
                IS_NEW.set(0);
            }
        }
        return IS_NEW.get() == 1;
    }

    private static boolean notEditable(World world, BlockPos pos, ServerPlayerEntity player, BlockState state) {
        if (QuarryChunkProtectionManager.hasProtectionMod()) {
            try {
                if (QuarryChunkProtectionManager.isOld()) {
                    return !ManagerOld.canEdit(world, pos, player, state);
                }
                if (QuarryChunkProtectionManager.isNew()) {
                    return !ManagerNew.canEdit(world, pos, player, state);
                }
                return false;
            }
            catch (Exception e) {
                IS_LOADED.set(0);
                LOGGER.error("Error happened in FTB Chunk check. MiningWell", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private static boolean notEditable(Area area, ServerPlayerEntity player) {
        if (QuarryChunkProtectionManager.hasProtectionMod()) {
            try {
                if (QuarryChunkProtectionManager.isOld()) {
                    return !ManagerOld.canEdit(area, player);
                }
                if (QuarryChunkProtectionManager.isNew()) {
                    return !ManagerNew.canEdit(area, player);
                }
                return false;
            }
            catch (Exception e) {
                IS_LOADED.set(0);
                LOGGER.error("Error happened in FTB Chunk check. Quarry", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static Consumer<TileMiningWell> minerSendProtectionNotification(LivingEntity placer) {
        if (QuarryChunkProtectionManager.hasProtectionMod()) {
            return t -> {
                World world = t.func_145831_w();
                if (world instanceof ServerWorld) {
                    ServerWorld serverWorld = (ServerWorld)world;
                    QuarryFakePlayer player = QuarryFakePlayer.get(serverWorld, t.func_174877_v());
                    if (QuarryChunkProtectionManager.notEditable((World)serverWorld, t.func_174877_v(), (ServerPlayerEntity)player, Blocks.field_150350_a.func_176223_P())) {
                        placer.func_145747_a((ITextComponent)new StringTextComponent(MESSAGE), Util.field_240973_b_);
                    }
                }
            };
        }
        return t -> {};
    }

    public static <T extends TileQuarry> Consumer<T> quarrySendProtectionNotification(LivingEntity placer) {
        if (QuarryChunkProtectionManager.hasProtectionMod()) {
            return t -> QuarryChunkProtectionManager.sendMessageWithArea(placer, t, Area.apply(t.xMin, t.yMax, t.zMin, t.xMax, t.yMax, t.zMax, (Option<ResourceLocation>)Option.apply((Object)t.func_145831_w()).map(v1 -> v1.func_234923_W_().func_240901_a_())));
        }
        return t -> {};
    }

    public static <T extends TileEntity> Consumer<T> sendProtectionNotification(LivingEntity placer) {
        if (QuarryChunkProtectionManager.hasProtectionMod()) {
            return t -> QuarryChunkProtectionManager.sendMessageWithArea(placer, t, ((IRemotePowerOn)t).getArea());
        }
        return t -> {};
    }

    private static void sendMessageWithArea(LivingEntity placer, TileEntity t, Area area) {
        ServerWorld serverWorld;
        QuarryFakePlayer player;
        World world = t.func_145831_w();
        if (world instanceof ServerWorld && QuarryChunkProtectionManager.notEditable(area, (ServerPlayerEntity)(player = QuarryFakePlayer.get(serverWorld = (ServerWorld)world, t.func_174877_v())))) {
            placer.func_145747_a((ITextComponent)new StringTextComponent(MESSAGE), Util.field_240973_b_);
        }
    }
}

