/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.yogpc.qp.machines.workbench.IngredientWithCount;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.javaapi.CollectionConverters;

public class SerializeUtils {
    static JsonArray serializeIngredients(Seq<IngredientWithCount> inputs) {
        return SerializeUtils.toJsonArray(inputs, IngredientWithCount::serializeJson);
    }

    static JsonArray makeConditionArray(List<ICondition> conditions) {
        return SerializeUtils.toJsonArray(conditions, CraftingHelper::serialize);
    }

    public static <T> JsonArray toJsonArray(Seq<T> data, Function<T, JsonElement> toJson) {
        return CollectionConverters.asJava(data).stream().map(toJson).reduce(new JsonArray(), (a, d) -> {
            a.add(d);
            return a;
        }, (a1, a2) -> {
            a1.addAll(a2);
            return a1;
        });
    }

    static StandaloneLootEntry.Builder<?> builder(Block block, Seq<ILootFunction.IBuilder> functions) {
        StandaloneLootEntry.Builder b = ItemLootEntry.func_216168_a((IItemProvider)block);
        CollectionConverters.asJava(functions).forEach(arg_0 -> ((StandaloneLootEntry.Builder)b).func_212841_b_(arg_0));
        return b;
    }
}

