/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.compat;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.compat.IInjector;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.registries.ObjectHolder;
import scala.Option;

public class InvUtils {
    @ObjectHolder(value="ic2:meter")
    public static final Item ic2_meter = new Item(new Item.Properties());
    @ObjectHolder(value="ic2:wrench")
    public static final Item ic2_wrench = new Item(new Item.Properties());
    @ObjectHolder(value="ic2:electric_wrench")
    public static final Item ic2_electric_wrench = new Item(new Item.Properties());
    @ObjectHolder(value="quarryplus:quarrydebug")
    public static final Item quarryDebug = new Item(new Item.Properties());
    @ObjectHolder(value="cofhcore:smelting")
    public static final Enchantment cofh_smelting = DummyEnchantment.access$100();
    @ObjectHolder(value="endercore:autosmelt")
    public static final Enchantment endercore_smelting = DummyEnchantment.access$100();

    public static ItemStack injectToNearTile(@Nonnull World w, @Nonnull BlockPos pos, ItemStack is) {
        BlockState state = w.func_180495_p(pos);
        Stream<Direction> directionStream = InvUtils.clockwiseDirections(state.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H) : null);
        List injectors = directionStream.flatMap(enumFacing -> Stream.of(w.func_175625_s(pos.func_177972_a(enumFacing))).filter(Objects::nonNull).flatMap(tile -> InjectorHolder.INJECTORS.stream().flatMap(i -> i.getInjector(is, (TileEntity)tile, (Direction)enumFacing)))).collect(Collectors.toList());
        ItemStack inserted = is.func_77946_l();
        for (IInjector injector : injectors) {
            inserted = injector.inject(inserted, w, pos);
            if (!inserted.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return inserted;
    }

    public static Stream<Direction> clockwiseDirections(@Nullable Direction blockDirection) {
        if (blockDirection == null) {
            return Stream.of(Direction.values());
        }
        switch (blockDirection) {
            case UP: {
                return Stream.concat(Stream.of(Direction.UP), Stream.concat(Stream.iterate(Direction.NORTH, Direction::func_176746_e).limit(4L), Stream.of(Direction.DOWN)));
            }
            case DOWN: {
                return Stream.concat(Stream.of(Direction.DOWN), Stream.concat(Stream.iterate(Direction.NORTH, Direction::func_176746_e).limit(4L), Stream.of(Direction.UP)));
            }
        }
        return Stream.concat(Stream.iterate(blockDirection, Direction::func_176746_e).limit(4L), Stream.of(Direction.UP, Direction.DOWN));
    }

    @Deprecated
    public static Option<IItemHandler> findItemHandler(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Direction from) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity == null) {
            return Option.empty();
        }
        LazyOptional capability = entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, from);
        if (capability.isPresent()) {
            return Option.apply((Object)capability.orElse((Object)EmptyHandler.INSTANCE));
        }
        return Option.empty();
    }

    public static void dropAndUpdateInv(World world, BlockPos pos, IInventory inventory, Block block) {
        if (inventory != null) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)inventory);
            world.func_175666_e(pos, block);
        }
    }

    public static ActionResultType isDebugItem(@Nonnull PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            if (item == quarryDebug || item == ic2_meter || item == ic2_wrench || item == ic2_electric_wrench) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    public static boolean hasSmelting(ItemStack stack) {
        return cofh_smelting != DummyEnchantment.DUMMY_ENCHANTMENT && EnchantmentHelper.func_77506_a((Enchantment)cofh_smelting, (ItemStack)stack) > 0 || endercore_smelting != DummyEnchantment.DUMMY_ENCHANTMENT && EnchantmentHelper.func_77506_a((Enchantment)endercore_smelting, (ItemStack)stack) > 0;
    }

    private static final class DummyEnchantment
    extends Enchantment {
        private static final DummyEnchantment DUMMY_ENCHANTMENT = new DummyEnchantment();

        DummyEnchantment() {
            super(Enchantment.Rarity.COMMON, EnchantmentType.BREAKABLE, new EquipmentSlotType[0]);
        }
    }

    private static class ForgeInjector
    implements IInjector {
        private final IItemHandler handler;

        private ForgeInjector(IItemHandler handler) {
            this.handler = handler;
        }

        @Override
        public Stream<? extends IInjector> getInjector(ItemStack stack, TileEntity entity, Direction facing) {
            return entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()).filter(h -> stack.func_190916_E() != ItemHandlerHelper.insertItemStacked((IItemHandler)h, (ItemStack)stack, (boolean)true).func_190916_E()).map(ForgeInjector::new).map(Stream::of).orElse(Stream.empty());
        }

        @Override
        public ItemStack inject(ItemStack stack, World world, BlockPos fromPos) {
            return ItemHandlerHelper.insertItem((IItemHandler)this.handler, (ItemStack)stack, (boolean)false);
        }
    }

    private static class InjectorHolder {
        private static final List<IInjector> INJECTORS;

        private InjectorHolder() {
        }

        static {
            Stream.Builder<IInjector> builder = Stream.builder();
            if (ModList.get().isLoaded("buildcraftlib")) {
                try {
                    builder.add((IInjector)Class.forName("com.yogpc.qp.compat.BCInjector").getMethod("init", new Class[0]).invoke(null, new Object[0]));
                }
                catch (ReflectiveOperationException e) {
                    QuarryPlus.LOGGER.error("Error occurred in initializing build craft injector.", (Throwable)e);
                }
            }
            if (ModList.get().isLoaded("mekanism")) {
                try {
                    builder.add((IInjector)Class.forName("com.yogpc.qp.compat.MekanismInjector").getMethod("init", new Class[0]).invoke(null, new Object[0]));
                }
                catch (ReflectiveOperationException e) {
                    QuarryPlus.LOGGER.error("Error occurred in initializing Mekanism injector.", (Throwable)e);
                }
            }
            builder.add(new ForgeInjector(EmptyHandler.INSTANCE));
            INJECTORS = Collections.unmodifiableList(builder.build().filter(Objects::nonNull).collect(Collectors.toList()));
        }
    }
}

