/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.marker.packet;

import com.kotori316.marker.TileFlexMarker;
import com.kotori316.marker.packet.AreaMessage;
import com.kotori316.marker.packet.PacketHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class ButtonMessage {
    private BlockPos pos;
    private RegistryKey<World> dim;
    private TileFlexMarker.Movable movable;
    private int amount;

    public ButtonMessage() {
    }

    public ButtonMessage(BlockPos pos, RegistryKey<World> dim, TileFlexMarker.Movable movable, int amount) {
        this.pos = pos;
        this.dim = dim;
        this.movable = movable;
        this.amount = amount;
    }

    public static ButtonMessage fromBytes(PacketBuffer p) {
        ButtonMessage message = new ButtonMessage();
        message.pos = p.func_179259_c();
        message.dim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)p.func_192575_l());
        message.movable = (TileFlexMarker.Movable)p.func_179257_a(TileFlexMarker.Movable.class);
        message.amount = p.readInt();
        return message;
    }

    public void toBytes(PacketBuffer p) {
        p.func_179255_a(this.pos).func_192572_a(this.dim.func_240901_a_());
        p.func_179249_a((Enum)this.movable).writeInt(this.amount);
    }

    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Optional.ofNullable(((NetworkEvent.Context)ctx.get()).getSender()).map(Entity::func_130014_f_).map(world -> world.func_175625_s(this.pos)).filter(t -> t instanceof TileFlexMarker && PacketHandler.getDimId(t.func_145831_w()) == this.dim).ifPresent(entity -> {
            TileFlexMarker marker = (TileFlexMarker)entity;
            marker.move(this.movable, this.amount);
            PacketHandler.sendToClient(new AreaMessage(this.pos, this.dim, marker.min(), marker.max()), marker.func_145831_w());
        }));
    }
}

