/*
 * Decompiled with CFR 0.152.
 */
package tfar.tanknull.inventory;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tfar.tanknull.inventory.IMultiTank;

public class FluidStackHandler
implements IMultiTank,
INBTSerializable<CompoundNBT> {
    protected NonNullList<FluidStack> stacks;
    protected int capacity;

    public FluidStackHandler(int tanks, int capacity) {
        this.stacks = NonNullList.func_191197_a((int)tanks, (Object)FluidStack.EMPTY);
        this.capacity = capacity;
    }

    public FluidStackHandler(int capacity) {
        this(1, capacity);
    }

    public FluidStackHandler setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public FluidStackHandler setSize(int tanks) {
        this.stacks = NonNullList.func_191197_a((int)tanks, (Object)FluidStack.EMPTY);
        return this;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return (FluidStack)this.stacks.get(tank);
    }

    public NonNullList<FluidStack> getContents() {
        return this.stacks;
    }

    public int getTanks() {
        return this.stacks.size();
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int totalFill = 0;
        FluidStack rem = resource.copy();
        for (int i = 0; i < this.getTanks(); ++i) {
            if (rem.isEmpty()) continue;
            int singleFill = this.fill(i, rem, action);
            totalFill += singleFill;
            rem = new FluidStack(resource, rem.getAmount() - singleFill);
        }
        return totalFill;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack totalDrain = FluidStack.EMPTY;
        FluidStack toDrain = resource.copy();
        for (int i = 0; i < this.getTanks(); ++i) {
            if (toDrain.isEmpty()) continue;
            FluidStack singleDrain = this.drain(i, toDrain, action);
            if (totalDrain.isEmpty()) {
                totalDrain = singleDrain.copy();
            } else {
                totalDrain.grow(singleDrain.getAmount());
            }
            toDrain = new FluidStack(toDrain, toDrain.getAmount() - singleDrain.getAmount());
        }
        return totalDrain;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack totalDrainStack = FluidStack.EMPTY;
        int toDrain = maxDrain;
        for (int i = 0; i < this.getTanks(); ++i) {
            if (toDrain <= 0) continue;
            FluidStack singleDrain = this.drain(i, toDrain, action);
            if (totalDrainStack.isEmpty()) {
                totalDrainStack = singleDrain.copy();
            } else {
                totalDrainStack.grow(singleDrain.getAmount());
            }
            toDrain -= singleDrain.getAmount();
        }
        return totalDrainStack;
    }

    @Override
    public int fill(int tank, FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(tank, resource)) {
            return 0;
        }
        FluidStack existingFluid = this.getFluidInTank(tank);
        if (!existingFluid.isFluidEqual(resource) && !existingFluid.isEmpty()) {
            return 0;
        }
        this.validateSlotIndex(tank);
        if (existingFluid.isEmpty()) {
            if (action.execute()) {
                this.stacks.set(tank, (Object)new FluidStack(resource, Math.min(this.capacity, resource.getAmount())));
                this.onContentsChanged(tank);
            }
            return resource.getAmount();
        }
        int filled = this.capacity - existingFluid.getAmount();
        if (resource.getAmount() < filled) {
            if (action.execute()) {
                existingFluid.grow(resource.getAmount());
            }
            filled = resource.getAmount();
        } else if (action.execute()) {
            existingFluid.setAmount(this.capacity);
        }
        if (filled > 0 && action.execute()) {
            this.onContentsChanged(tank);
        }
        return filled;
    }

    @Override
    @Nonnull
    public FluidStack drain(int tank, FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.getFluidInTank(tank)) || !this.isFluidValid(tank, resource)) {
            return FluidStack.EMPTY;
        }
        return this.drain(tank, resource.getAmount(), action);
    }

    @Override
    @Nonnull
    public FluidStack drain(int tank, int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        this.validateSlotIndex(tank);
        FluidStack existingFluid = this.getFluidInTank(tank);
        if (existingFluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int drained = maxDrain;
        if (existingFluid.getAmount() <= maxDrain) {
            drained = existingFluid.getAmount();
            if (action.execute()) {
                this.stacks.set(tank, (Object)FluidStack.EMPTY);
                this.onContentsChanged(tank);
            }
        } else if (action.execute()) {
            this.stacks.set(tank, (Object)new FluidStack(existingFluid, existingFluid.getAmount() - drained));
            this.onContentsChanged(tank);
        }
        return new FluidStack(existingFluid, drained);
    }

    public void setStackInSlot(int slot, @Nonnull FluidStack stack) {
        this.validateSlotIndex(slot);
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    public CompoundNBT serializeNBT() {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((FluidStack)this.stacks.get(i)).isEmpty()) continue;
            CompoundNBT fluidTag = new CompoundNBT();
            fluidTag.func_74768_a("Tank", i);
            ((FluidStack)this.stacks.get(i)).writeToNBT(fluidTag);
            nbtTagList.add((Object)fluidTag);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Fluids", (INBT)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.size());
        nbt.func_74768_a("Capacity", this.capacity);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setCapacity(nbt.func_150297_b("Capacity", 3) ? nbt.func_74762_e("Capacity") : this.capacity);
        this.setSize(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size());
        ListNBT tagList = nbt.func_150295_c("Fluids", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT fluidTags = tagList.func_150305_b(i);
            int tank = fluidTags.func_74762_e("Tank");
            if (tank < 0 || tank >= this.stacks.size()) continue;
            this.stacks.set(tank, (Object)FluidStack.loadFluidStackFromNBT((CompoundNBT)fluidTags));
        }
        this.onLoad();
    }

    protected void onLoad() {
    }

    public void onContentsChanged(int slot) {
    }

    protected void validateSlotIndex(int tank) {
        if (tank < 0 || tank >= this.stacks.size()) {
            throw new RuntimeException("Tank " + tank + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    public boolean isEmpty() {
        return this.stacks.stream().allMatch(FluidStack::isEmpty);
    }
}

