/*
 * Decompiled with CFR 0.152.
 */
package tfar.tanknull;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import tfar.tanknull.RegistryObjects;
import tfar.tanknull.TankNullItem;
import tfar.tanknull.TankStats;
import tfar.tanknull.inventory.TankNullItemStackFluidStackHandler;

public class Utils {
    public static final String FLUIDINV = "fluidinv";
    public static boolean DEV;

    public static TankStats getStats(ItemStack tank) {
        return ((TankNullItem)tank.func_77973_b()).stats;
    }

    public static int getTanks(Item block) {
        return ((TankNullItem)block).stats.slots;
    }

    public static Item getItem(int tier) {
        switch (tier) {
            case 1: {
                return RegistryObjects.tank_1;
            }
            case 2: {
                return RegistryObjects.tank_2;
            }
            case 3: {
                return RegistryObjects.tank_3;
            }
            case 4: {
                return RegistryObjects.tank_4;
            }
            case 5: {
                return RegistryObjects.tank_5;
            }
            case 6: {
                return RegistryObjects.tank_6;
            }
            case 7: {
                return RegistryObjects.tank_7;
            }
        }
        throw new IllegalArgumentException("no " + tier);
    }

    public static int getTanks(ItemStack stack) {
        Item block = stack.func_77973_b();
        return Utils.getTanks(block);
    }

    public static int getCapacity(ItemStack stack) {
        Item block = stack.func_77973_b();
        return Utils.getCapacity(block);
    }

    public static int getCapacity(Item block) {
        return ((TankNullItem)block).stats.capacity;
    }

    public static boolean isFill(ItemStack bag, PlayerEntity player) {
        return TankNullItemStackFluidStackHandler.create((ItemStack)bag).isFill;
    }

    public static void toggleFill(ItemStack bag, PlayerEntity player) {
        TankNullItemStackFluidStackHandler handler = TankNullItemStackFluidStackHandler.create(bag);
        handler.toggleFill();
        player.func_146105_b((ITextComponent)new TranslationTextComponent("text.tanknull.mode." + (handler.isFill ? "fill" : "empty")), true);
    }

    public static boolean isSponge(ItemStack bag, PlayerEntity player) {
        return TankNullItemStackFluidStackHandler.create((ItemStack)bag).sponge;
    }

    public static void toggleSponge(ItemStack bag, PlayerEntity player) {
        TankNullItemStackFluidStackHandler.create(bag).toggleSponge();
    }

    public static void changeSlot(ItemStack bag, boolean right) {
        TankNullItemStackFluidStackHandler.create(bag).scroll(right);
    }

    public static Item.Properties copy(Item from) {
        return new Item.Properties().func_200919_a(from.func_77668_q()).func_200918_c(from.func_77612_l()).func_200917_a(from.func_77639_j()).func_200916_a(from.func_77640_w()).func_221540_a(from.func_219967_s()).func_208103_a(new ItemStack((IItemProvider)from).func_77953_t());
    }

    public static ICapabilityProvider createFluidProvider(IFluidHandlerItem iFluidHandler) {
        return new Provider((IFluidHandler)iFluidHandler);
    }

    static {
        try {
            Items.class.getField("field_190931_a");
            DEV = false;
        }
        catch (NoSuchFieldException e) {
            DEV = true;
        }
    }

    public static class Provider
    implements ICapabilityProvider {
        final LazyOptional<IFluidHandler> capability = LazyOptional.of(() -> iFluidHandler);

        Provider(IFluidHandler iFluidHandler) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, this.capability);
        }
    }
}

