/*
 * Decompiled with CFR 0.152.
 */
package tfar.tanknull;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tfar.tanknull.DockBlock;
import tfar.tanknull.TankStats;
import tfar.tanknull.Utils;
import tfar.tanknull.client.TankNullClient;
import tfar.tanknull.inventory.TankNullItemStackFluidStackHandler;

public class TankNullItem
extends Item {
    public final TankStats stats;

    public TankNullItem(Item.Properties builder, TankStats stats) {
        super(builder);
        this.stats = stats;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World p_190948_2_, List<ITextComponent> tooltip, ITooltipFlag p_190948_4_) {
        if (stack.func_77942_o() && Utils.DEV) {
            tooltip.add((ITextComponent)new StringTextComponent(stack.func_77978_p().toString()).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        CompoundNBT nbt = stack.func_77978_p();
        tooltip.add((ITextComponent)new TranslationTextComponent("text.tanknull.stacklimit", new Object[]{Utils.getCapacity(this)}));
        if (nbt != null && !nbt.func_74775_l("fluidinv").isEmpty()) {
            CompoundNBT fluidTag = nbt.func_74775_l("fluidinv");
            IFormattableTextComponent text = new TranslationTextComponent("text.tanknull.mode", new Object[]{fluidTag.func_74767_n("fill") ? new TranslationTextComponent("text.tanknull.mode.fill").func_240699_a_(TextFormatting.AQUA) : new TranslationTextComponent("text.tanknull.mode.empty").func_240699_a_(TextFormatting.AQUA)}).func_230529_a_((ITextComponent)new TranslationTextComponent(" Alt + Right Click to swap").func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)text);
            tooltip.add((ITextComponent)new TranslationTextComponent("text.tanknull.settings", new Object[]{TankNullClient.MODE.func_238171_j_().func_230531_f_().func_240699_a_(TextFormatting.YELLOW)}));
            boolean sponge = fluidTag.func_74767_n("sponge");
            if (sponge) {
                tooltip.add((ITextComponent)new StringTextComponent("Sponge"));
            }
            ListNBT tagList = fluidTag.func_150295_c("Fluids", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT fluidTags = tagList.func_150305_b(i);
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundNBT)fluidTags);
                if (fluidStack.isEmpty()) continue;
                tooltip.add((ITextComponent)new TranslationTextComponent("text.tanknull.formatcontainedfluids", new Object[]{new StringTextComponent(String.valueOf(i)).func_240699_a_(TextFormatting.GREEN), new StringTextComponent(String.valueOf(fluidStack.getAmount())).func_240699_a_(TextFormatting.AQUA), fluidStack.getDisplayName()}).func_240699_a_(TextFormatting.WHITE));
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            TankNullItemStackFluidStackHandler handler = TankNullItemStackFluidStackHandler.create(itemstack);
            boolean filling = handler.isFill;
            if (filling) {
                return this.fill(world, player, hand, itemstack, handler);
            }
            return this.empty(world, player, hand, itemstack, handler);
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public ActionResult<ItemStack> fill(World world, PlayerEntity player, Hand hand, ItemStack itemstack, TankNullItemStackFluidStackHandler handler) {
        FluidStack selectedFluidStack = handler.getFluidInTank(handler.selectedTank);
        BlockRayTraceResult raytraceresult = TankNullItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)player, (World)world, (ItemStack)itemstack, (RayTraceResult)raytraceresult);
        if (ret != null) {
            return ret;
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        BlockPos tracedPos = raytraceresult.func_216350_a();
        Direction direction = raytraceresult.func_216354_b();
        BlockPos offsetPos = tracedPos.func_177972_a(direction);
        if (world.func_175660_a(player, tracedPos) && player.func_175151_a(offsetPos, direction, itemstack)) {
            BlockState rayTracedState = world.func_180495_p(tracedPos);
            if (rayTracedState.func_177230_c() instanceof IBucketPickupHandler) {
                Fluid fluid = Fluids.field_204541_a;
                if (rayTracedState.func_177230_c() instanceof IWaterLoggable) {
                    fluid = Fluids.field_204546_a;
                } else if (rayTracedState.func_177230_c() instanceof FlowingFluidBlock) {
                    fluid = ((FlowingFluidBlock)rayTracedState.func_177230_c()).getFluid();
                }
                if (fluid != Fluids.field_204541_a && handler.hasRoomForFluid(new FluidStack(fluid, 1000))) {
                    ((IBucketPickupHandler)rayTracedState.func_177230_c()).func_204508_a((IWorld)world, tracedPos, rayTracedState);
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                    SoundEvent soundevent = selectedFluidStack.getFluid().getAttributes().getEmptySound();
                    if (soundevent == null) {
                        soundevent = fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                    }
                    player.func_184185_a(soundevent, 1.0f, 1.0f);
                    return ActionResult.func_226249_b_((Object)this.fillBucketFromBlock(fluid, itemstack, handler, player));
                }
            }
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public ActionResult<ItemStack> empty(World world, PlayerEntity player, Hand hand, ItemStack itemstack, TankNullItemStackFluidStackHandler handler) {
        FluidStack selectedFluidStack = handler.getFluidInTank(handler.selectedTank);
        boolean smart = handler.smartPlacing;
        if (selectedFluidStack.isEmpty()) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        selectedFluidStack.isEmpty();
        BlockRayTraceResult raytraceresult = TankNullItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)player, (World)world, (ItemStack)itemstack, (RayTraceResult)raytraceresult);
        if (ret != null) {
            return ret;
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        BlockPos rayTracePoa = raytraceresult.func_216350_a();
        Direction direction = raytraceresult.func_216354_b();
        BlockPos placingPosition = rayTracePoa.func_177972_a(direction);
        if (world.func_175660_a(player, rayTracePoa) && player.func_175151_a(placingPosition, direction, itemstack)) {
            if (this.tryPlaceContainedLiquid(player, world, smart ? placingPosition : rayTracePoa, raytraceresult, selectedFluidStack)) {
                this.onLiquidPlaced(world, itemstack, placingPosition);
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, placingPosition, itemstack);
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                return ActionResult.func_226249_b_((Object)this.emptyBucket(itemstack, handler, player));
            }
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        return ActionResult.func_226250_c_((Object)itemstack);
    }

    protected ItemStack emptyBucket(ItemStack current, TankNullItemStackFluidStackHandler handler, PlayerEntity player) {
        handler.drain1000(IFluidHandler.FluidAction.EXECUTE);
        return current;
    }

    public void onLiquidPlaced(World worldIn, ItemStack p_203792_2_, BlockPos pos) {
    }

    protected ItemStack fillBucketFromBlock(Fluid fluid, ItemStack emptyBucket, TankNullItemStackFluidStackHandler handler, PlayerEntity player) {
        handler.fill1000(IFluidHandler.FluidAction.EXECUTE, fluid);
        return emptyBucket;
    }

    public boolean tryPlaceContainedLiquid(@Nullable PlayerEntity player, World worldIn, BlockPos posIn, @Nullable BlockRayTraceResult result, FluidStack selectedFluidStack) {
        boolean flag1;
        if (!(selectedFluidStack.getFluid() instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockstate = worldIn.func_180495_p(posIn);
        Block block = blockstate.func_177230_c();
        Material material = blockstate.func_185904_a();
        boolean flag = blockstate.func_227032_a_(selectedFluidStack.getFluid());
        boolean bl = flag1 = blockstate.func_196958_f() || flag || block instanceof ILiquidContainer && ((ILiquidContainer)block).func_204510_a((IBlockReader)worldIn, posIn, blockstate, selectedFluidStack.getFluid());
        if (!flag1) {
            return result != null && this.tryPlaceContainedLiquid(player, worldIn, result.func_216350_a().func_177972_a(result.func_216354_b()), null, selectedFluidStack);
        }
        if (blockstate.func_196958_f() || flag || blockstate.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)blockstate.func_177230_c()).func_204510_a((IBlockReader)worldIn, posIn, blockstate, selectedFluidStack.getFluid())) {
            if (worldIn.func_230315_m_().func_236040_e_() && selectedFluidStack.getFluid().func_207185_a((ITag)FluidTags.field_206959_a)) {
                int i = posIn.func_177958_n();
                int j = posIn.func_177956_o();
                int k = posIn.func_177952_p();
                worldIn.func_184133_a(player, posIn, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (blockstate.func_177230_c() instanceof ILiquidContainer && selectedFluidStack.getFluid() == Fluids.field_204546_a) {
                if (((ILiquidContainer)blockstate.func_177230_c()).func_204509_a((IWorld)worldIn, posIn, blockstate, ((FlowingFluid)selectedFluidStack.getFluid()).func_207204_a(false))) {
                    this.playEmptySound(player, (IWorld)worldIn, posIn, selectedFluidStack);
                }
            } else {
                if (!worldIn.field_72995_K && flag && !material.func_76224_d()) {
                    worldIn.func_175655_b(posIn, true);
                }
                this.playEmptySound(player, (IWorld)worldIn, posIn, selectedFluidStack);
                worldIn.func_180501_a(posIn, selectedFluidStack.getFluid().func_207188_f().func_206883_i(), 11);
            }
            return true;
        }
        return result != null && this.tryPlaceContainedLiquid(player, worldIn, result.func_216350_a().func_177972_a(result.func_216354_b()), null, selectedFluidStack);
    }

    protected void playEmptySound(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos, FluidStack fluidStack) {
        SoundEvent soundevent = fluidStack.getFluid().getAttributes().getEmptySound();
        if (soundevent == null) {
            soundevent = fluidStack.getFluid().func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        worldIn.func_184133_a(player, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return Utils.createFluidProvider(TankNullItemStackFluidStackHandler.create(stack));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockPos pos = ctx.func_195995_a();
        World world = ctx.func_195991_k();
        BlockState state = world.func_180495_p(pos);
        TileEntity blockentity = world.func_175625_s(pos);
        if (!(state.func_177230_c() instanceof DockBlock) && blockentity != null) {
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }
}

