/*
 * Decompiled with CFR 0.152.
 */
package tfar.tanknull;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tfar.tanknull.DockBlock;
import tfar.tanknull.RegistryObjects;
import tfar.tanknull.TankNullItem;
import tfar.tanknull.TankStats;
import tfar.tanknull.Utils;
import tfar.tanknull.container.BlockTankNullMenu;
import tfar.tanknull.inventory.TankNullBlockFluidStackHandler;

public class TankNullDockBlockEntity
extends TileEntity
implements INamedContainerProvider {
    public TankNullBlockFluidStackHandler handler = new TankNullBlockFluidStackHandler(TankStats.zero){

        @Override
        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TankNullDockBlockEntity.this.func_70296_d();
        }
    };
    private LazyOptional<IFluidHandler> optional = LazyOptional.of(() -> this.handler);

    public TankNullDockBlockEntity() {
        super(RegistryObjects.blockentity);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.loadRestorable(compound);
        super.func_230337_a_(state, compound);
    }

    public void loadRestorable(@Nullable CompoundNBT compound) {
        if (compound != null && compound.func_74764_b("fluidinv")) {
            CompoundNBT tanks = (CompoundNBT)compound.func_74781_a("fluidinv");
            this.handler.deserializeNBT(tanks);
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT tanks = this.handler.serializeNBT();
        compound.func_218657_a("fluidinv", (INBT)tanks);
        return super.func_189515_b(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.optional.cast() : super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("Tank Null");
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        int tier = (Integer)this.func_195044_w().func_177229_b((Property)DockBlock.TIER);
        switch (tier) {
            case 1: {
                return BlockTankNullMenu.t1s(i, playerInventory, this.handler);
            }
            case 2: {
                return BlockTankNullMenu.t2s(i, playerInventory, this.handler);
            }
            case 3: {
                return BlockTankNullMenu.t3s(i, playerInventory, this.handler);
            }
            case 4: {
                return BlockTankNullMenu.t4s(i, playerInventory, this.handler);
            }
            case 5: {
                return BlockTankNullMenu.t5s(i, playerInventory, this.handler);
            }
            case 6: {
                return BlockTankNullMenu.t6s(i, playerInventory, this.handler);
            }
            case 7: {
                return BlockTankNullMenu.t7s(i, playerInventory, this.handler);
            }
        }
        return null;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("fluidinv", (INBT)this.handler.serializeNBT());
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbt);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_218657_a("fluidinv", (INBT)this.handler.serializeNBT());
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.handler.deserializeNBT((CompoundNBT)packet.func_148857_g().func_74781_a("fluidinv"));
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.optional.invalidate();
    }

    public void removeTank() {
        int tier = (Integer)this.func_195044_w().func_177229_b((Property)DockBlock.TIER);
        CompoundNBT nbt = this.handler.serializeNBT();
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)DockBlock.TIER, (Comparable)Integer.valueOf(0)));
        this.optional.invalidate();
        ItemStack stack = new ItemStack((IItemProvider)Utils.getItem(tier));
        stack.func_196082_o().func_218657_a("fluidinv", (INBT)nbt);
        ItemEntity entity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), stack);
        this.field_145850_b.func_217376_c((Entity)entity);
    }

    public void addTank(ItemStack tank) {
        if (tank.func_77973_b() instanceof TankNullItem) {
            int tier = Utils.getStats(tank).ordinal();
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)DockBlock.TIER, (Comparable)Integer.valueOf(tier)));
            this.handler.setCapacity(Utils.getCapacity(tank)).setSize(Utils.getTanks(tank));
            this.handler.deserializeNBT(tank.func_196082_o().func_74775_l("fluidinv"));
            this.optional = LazyOptional.of(() -> this.handler);
            tank.func_190918_g(1);
        }
    }

    public void writeFluids(PacketBuffer buf) {
        NonNullList<FluidStack> stacks = this.handler.getContents();
        for (int i = 0; i < stacks.size(); ++i) {
            FluidStack stack = (FluidStack)stacks.get(i);
            buf.writeFluidStack(stack);
        }
    }
}

