/*
 * Decompiled with CFR 0.152.
 */
package tfar.tanknull;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tfar.tanknull.BlockTankNullScreen;
import tfar.tanknull.RegistryObjects;
import tfar.tanknull.TankNullItem;
import tfar.tanknull.Utils;
import tfar.tanknull.client.ItemStackTankNullScreen;
import tfar.tanknull.client.TankNullClient;
import tfar.tanknull.inventory.TankNullItemStackFluidStackHandler;
import tfar.tanknull.network.Messages;

@Mod(value="tanknull")
public class TankNull {
    public static final String MODID = "tanknull";
    private static final Logger LOGGER = LogManager.getLogger();

    public TankNull() {
        IEventBus iEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        iEventBus.addListener(this::setup);
        iEventBus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.addListener(this::sponge);
        iEventBus.addGenericListener(Item.class, this::items);
        iEventBus.addGenericListener(Block.class, this::blocks);
        iEventBus.addGenericListener(ContainerType.class, this::menus);
        iEventBus.addGenericListener(TileEntityType.class, this::blockentities);
        iEventBus.addGenericListener(IRecipeSerializer.class, this::recipes);
    }

    private void blocks(RegistryEvent.Register<Block> event) {
        TankNull.register(event.getRegistry(), "dock", RegistryObjects.dock);
    }

    private void items(RegistryEvent.Register<Item> event) {
        TankNull.register(event.getRegistry(), "dock", RegistryObjects.dock_item);
        TankNull.register(event.getRegistry(), "tank_1", RegistryObjects.tank_1);
        TankNull.register(event.getRegistry(), "tank_2", RegistryObjects.tank_2);
        TankNull.register(event.getRegistry(), "tank_3", RegistryObjects.tank_3);
        TankNull.register(event.getRegistry(), "tank_4", RegistryObjects.tank_4);
        TankNull.register(event.getRegistry(), "tank_5", RegistryObjects.tank_5);
        TankNull.register(event.getRegistry(), "tank_6", RegistryObjects.tank_6);
        TankNull.register(event.getRegistry(), "tank_7", RegistryObjects.tank_7);
    }

    private void menus(RegistryEvent.Register<ContainerType<?>> event) {
        TankNull.register(event.getRegistry(), "tank_1", RegistryObjects.tank_1_container);
        TankNull.register(event.getRegistry(), "tank_2", RegistryObjects.tank_2_container);
        TankNull.register(event.getRegistry(), "tank_3", RegistryObjects.tank_3_container);
        TankNull.register(event.getRegistry(), "tank_4", RegistryObjects.tank_4_container);
        TankNull.register(event.getRegistry(), "tank_5", RegistryObjects.tank_5_container);
        TankNull.register(event.getRegistry(), "tank_6", RegistryObjects.tank_6_container);
        TankNull.register(event.getRegistry(), "tank_7", RegistryObjects.tank_7_container);
        TankNull.register(event.getRegistry(), "tank_1_portable", RegistryObjects.tank_1_portable);
        TankNull.register(event.getRegistry(), "tank_2_portable", RegistryObjects.tank_2_portable);
        TankNull.register(event.getRegistry(), "tank_3_portable", RegistryObjects.tank_3_portable);
        TankNull.register(event.getRegistry(), "tank_4_portable", RegistryObjects.tank_4_portable);
        TankNull.register(event.getRegistry(), "tank_5_portable", RegistryObjects.tank_5_portable);
        TankNull.register(event.getRegistry(), "tank_6_portable", RegistryObjects.tank_6_portable);
        TankNull.register(event.getRegistry(), "tank_7_portable", RegistryObjects.tank_7_portable);
    }

    private void blockentities(RegistryEvent.Register<TileEntityType<?>> event) {
        TankNull.register(event.getRegistry(), "dock", RegistryObjects.blockentity);
    }

    private void recipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        TankNull.register(event.getRegistry(), "upgrade", RegistryObjects.upgrade);
    }

    private static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, ResourceLocation name, T obj) {
        registry.register((IForgeRegistryEntry)obj.setRegistryName(name));
    }

    private static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, String name, T obj) {
        TankNull.register(registry, new ResourceLocation(MODID, name), obj);
    }

    private void setup(FMLCommonSetupEvent event) {
        Messages.registerMessages(MODID);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(RegistryObjects.tank_1_container, BlockTankNullScreen::new);
        ScreenManager.func_216911_a(RegistryObjects.tank_2_container, BlockTankNullScreen::new);
        ScreenManager.func_216911_a(RegistryObjects.tank_3_container, BlockTankNullScreen::new);
        ScreenManager.func_216911_a(RegistryObjects.tank_4_container, BlockTankNullScreen::new);
        ScreenManager.func_216911_a(RegistryObjects.tank_5_container, BlockTankNullScreen::new);
        ScreenManager.func_216911_a(RegistryObjects.tank_6_container, BlockTankNullScreen::new);
        ScreenManager.func_216911_a(RegistryObjects.tank_7_container, BlockTankNullScreen::new);
        ScreenManager.func_216911_a(RegistryObjects.tank_1_portable, ItemStackTankNullScreen::new);
        ScreenManager.func_216911_a(RegistryObjects.tank_2_portable, ItemStackTankNullScreen::new);
        ScreenManager.func_216911_a(RegistryObjects.tank_3_portable, ItemStackTankNullScreen::new);
        ScreenManager.func_216911_a(RegistryObjects.tank_4_portable, ItemStackTankNullScreen::new);
        ScreenManager.func_216911_a(RegistryObjects.tank_5_portable, ItemStackTankNullScreen::new);
        ScreenManager.func_216911_a(RegistryObjects.tank_6_portable, ItemStackTankNullScreen::new);
        ScreenManager.func_216911_a(RegistryObjects.tank_7_portable, ItemStackTankNullScreen::new);
        TankNullClient.MODE = new KeyBinding("key.tanknull.mode", 79, "key.categories.tanknull");
        ClientRegistry.registerKeyBinding((KeyBinding)TankNullClient.MODE);
    }

    private void sponge(TickEvent.PlayerTickEvent e) {
        PlayerEntity player = e.player;
        World world = player.field_70170_p;
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof TankNullItem && Utils.isSponge(stack, player) && e.phase == TickEvent.Phase.END && !world.field_72995_K) {
            BlockPos origin = player.func_233580_cy_();
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (int x = -4; x < 4; ++x) {
                for (int y = -4; y < 4; ++y) {
                    for (int z = -4; z < 4; ++z) {
                        mutable.func_181079_c(x + origin.func_177958_n(), y + origin.func_177956_o(), z + origin.func_177952_p());
                        BlockState state = world.func_180495_p((BlockPos)mutable);
                        if (!(state.func_177230_c() instanceof IBucketPickupHandler)) continue;
                        Fluid fluid = ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)world, (BlockPos)mutable, state);
                        TankNullItemStackFluidStackHandler.create(stack).fill1000(IFluidHandler.FluidAction.EXECUTE, fluid);
                    }
                }
            }
        }
    }
}

