/*
 * Decompiled with CFR 0.152.
 */
package tfar.tanknull;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import tfar.tanknull.TankNullDockBlockEntity;
import tfar.tanknull.TankNullItem;
import tfar.tanknull.inventory.FluidHandlerHelper;

public class DockBlock
extends Block {
    public static final IntegerProperty TIER = IntegerProperty.func_177719_a((String)"tier", (int)0, (int)7);
    public static final VoxelShape EMPTY;
    public static final VoxelShape DOCKED;

    public DockBlock(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        PlayerEntity player;
        if (context.getEntity() instanceof PlayerEntity && (player = (PlayerEntity)context.getEntity()).func_184614_ca().func_77973_b() instanceof TankNullItem) {
            return DOCKED;
        }
        return (Integer)state.func_177229_b((Property)TIER) > 0 ? DOCKED : EMPTY;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult p_225533_6_) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TankNullDockBlockEntity) {
            TankNullDockBlockEntity tankNullDockBlockEntity = (TankNullDockBlockEntity)tile;
            int blockTier = (Integer)state.func_177229_b((Property)TIER);
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b() instanceof TankNullItem && blockTier == 0) {
                ((TankNullDockBlockEntity)tile).addTank(player.func_184586_b(hand));
                return ActionResultType.SUCCESS;
            }
            if (stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
                FluidActionResult result;
                boolean isEmpty = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(iFluidHandlerItem -> IntStream.range(0, iFluidHandlerItem.getTanks()).allMatch(i -> iFluidHandlerItem.getFluidInTank(i).isEmpty())).orElse(true);
                FluidActionResult fluidActionResult = result = isEmpty ? FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)tankNullDockBlockEntity.handler, (IItemHandler)new InvWrapper((IInventory)player.field_71071_by), (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true) : FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)tankNullDockBlockEntity.handler, (IItemHandler)new InvWrapper((IInventory)player.field_71071_by), (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
                if (result.isSuccess()) {
                    player.func_184201_a(hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND, result.getResult());
                }
                return ActionResultType.SUCCESS;
            }
            if (player.func_213453_ef() && player.func_184586_b(hand).func_190926_b() && blockTier > 0) {
                ((TankNullDockBlockEntity)tile).removeTank();
            } else {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tile), ((TankNullDockBlockEntity)tile)::writeFluids);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TankNullDockBlockEntity();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TIER});
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity blockEntity = worldIn.func_175625_s(pos);
        return blockEntity instanceof TankNullDockBlockEntity ? FluidHandlerHelper.calcRedstoneFromInventory(((TankNullDockBlockEntity)blockEntity).handler) : 0;
    }

    static {
        VoxelShape a1 = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        VoxelShape b1 = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
        VoxelShape shape1 = VoxelShapes.func_197882_b((VoxelShape)a1, (VoxelShape)b1, (IBooleanFunction)IBooleanFunction.field_223236_g_);
        VoxelShape a2 = Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape b2 = Block.func_208617_a((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape shape2 = VoxelShapes.func_197882_b((VoxelShape)a2, (VoxelShape)b2, (IBooleanFunction)IBooleanFunction.field_223236_g_);
        VoxelShape p1 = Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0);
        VoxelShape p2 = Block.func_208617_a((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0);
        VoxelShape p3 = Block.func_208617_a((double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0);
        VoxelShape p4 = Block.func_208617_a((double)12.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0);
        EMPTY = VoxelShapes.func_216384_a((VoxelShape)shape1, (VoxelShape[])new VoxelShape[]{shape2, p1, p2, p3, p4});
        DOCKED = VoxelShapes.func_197872_a((VoxelShape)EMPTY, (VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0));
    }
}

