/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.create;

import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.blakebr0.mysticalcustomization.loader.MobSoulTypeLoader;
import com.blakebr0.mysticalcustomization.util.ParsingUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public final class MobSoulTypeCreator {
    public static IMobSoulType create(ResourceLocation id, JsonObject json) throws JsonSyntaxException {
        float souls = JSONUtils.func_151217_k((JsonObject)json, (String)"souls");
        MobSoulType type = new MobSoulType(id, (Set)Sets.newHashSet(), null, (double)souls, -1);
        if (json.has("entity")) {
            String entityId = JSONUtils.func_151200_h((JsonObject)json, (String)"entity");
            ResourceLocation entity2 = new ResourceLocation(entityId);
            MobSoulTypeLoader.ENTITY_ADDITIONS_MAP.put((IMobSoulType)type, Lists.newArrayList((Object[])new ResourceLocation[]{entity2}));
        } else if (json.has("entities")) {
            JsonArray entityIds = JSONUtils.func_151214_t((JsonObject)json, (String)"entities");
            ArrayList entities = new ArrayList();
            entityIds.forEach(entity -> entities.add(new ResourceLocation(entity.getAsString())));
            MobSoulTypeLoader.ENTITY_ADDITIONS_MAP.put((IMobSoulType)type, entities);
        } else {
            throw new JsonSyntaxException("Missing 'entity' or 'entities' property");
        }
        if (json.has("color")) {
            String color = JSONUtils.func_151200_h((JsonObject)json, (String)"color");
            int i = ParsingUtils.parseHex(color, "color");
            type.setColor(i);
        }
        if (json.has("name")) {
            String name = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
            type.setEntityDisplayName((ITextComponent)new StringTextComponent(name));
        }
        if (json.has("enabled")) {
            boolean enabled = JSONUtils.func_151212_i((JsonObject)json, (String)"enabled");
            type.setEnabled(enabled);
        }
        return type;
    }
}

