/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.item;

import jackyy.exchangers.client.keybind.Keys;
import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.exchangers.handler.mode.ModeHorizontalCol;
import jackyy.exchangers.handler.mode.ModePlane;
import jackyy.exchangers.handler.mode.ModeVerticalCol;
import jackyy.exchangers.registry.ModConfigs;
import jackyy.exchangers.util.IExchanger;
import jackyy.exchangers.util.ILoadable;
import jackyy.exchangers.util.Reference;
import jackyy.gunpowderlib.helper.KeyHelper;
import jackyy.gunpowderlib.helper.NBTHelper;
import jackyy.gunpowderlib.helper.StringHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemExchangerBase
extends Item
implements IExchanger,
ILoadable {
    public ItemExchangerBase(Item.Properties props) {
        super(props.func_200916_a(Reference.TAB));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77951_h();
    }

    @Override
    public boolean isPowered() {
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        if (!world.field_72995_K && player != null) {
            if (player.func_225608_bj_()) {
                ExchangerHandler.selectBlock(player.func_184614_ca(), player, world, pos);
            } else {
                ExchangerHandler.placeBlock(player.func_184614_ca(), player, world, pos, side, context);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        ExchangerHandler.setDefaultTagCompound(stack);
        CompoundNBT compound = NBTHelper.getTag((ItemStack)stack);
        BlockState state = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("blockstate"));
        Block block = state.func_177230_c();
        int mode = compound.func_74762_e("mode");
        if (!KeyHelper.isShiftKeyDown()) {
            tooltip.add((ITextComponent)StringHelper.getShiftText((String)"exchangers"));
        }
        if (KeyHelper.isShiftKeyDown()) {
            tooltip.add((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.selected_block", (Object[])new Object[]{block == Blocks.field_150350_a ? StringHelper.localize((String)"exchangers", (String)"tooltip.selected_block.none", (Object[])new Object[0]).func_240699_a_(TextFormatting.RED) : ExchangerHandler.getBlockName(block).func_240699_a_(TextFormatting.GREEN)}).func_240699_a_(TextFormatting.WHITE));
            tooltip.add((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.current_range", (Object[])new Object[]{TextFormatting.GREEN + ExchangerHandler.rangeList[compound.func_74762_e("range")]}).func_240699_a_(TextFormatting.WHITE));
            tooltip.add((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.max_range", (Object[])new Object[]{new StringTextComponent(ExchangerHandler.rangeList[this.getMaxRange()]).func_240699_a_(TextFormatting.GREEN)}).func_240699_a_(TextFormatting.WHITE));
            tooltip.add((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.max_harvest_level", (Object[])new Object[]{StringHelper.formatHarvestLevel((String)"exchangers", (int)this.getHarvestLevel()).func_240699_a_(TextFormatting.GREEN)}).func_240699_a_(TextFormatting.WHITE));
            switch (mode) {
                case 0: {
                    tooltip.add((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.current_mode", (Object[])new Object[]{ModePlane.getDisplayName().func_240699_a_(TextFormatting.GREEN)}).func_240699_a_(TextFormatting.WHITE));
                    break;
                }
                case 1: {
                    tooltip.add((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.current_mode", (Object[])new Object[]{ModeHorizontalCol.getDisplayName().func_240699_a_(TextFormatting.GREEN)}).func_240699_a_(TextFormatting.WHITE));
                    break;
                }
                case 2: {
                    tooltip.add((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.current_mode", (Object[])new Object[]{ModeVerticalCol.getDisplayName().func_240699_a_(TextFormatting.GREEN)}).func_240699_a_(TextFormatting.WHITE));
                }
            }
            tooltip.add((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.silk_touch", (Object[])new Object[]{Reference.getStateString((Boolean)ModConfigs.CONFIG.doExchangersSilkTouch.get())}).func_240699_a_(TextFormatting.WHITE));
            tooltip.add((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.force_drop_items", (Object[])new Object[]{Reference.getStateString(compound.func_74767_n("forceDropItems"))}).func_240699_a_(TextFormatting.WHITE));
            tooltip.add((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.directional_placement", (Object[])new Object[]{Reference.getStateString(compound.func_74767_n("directionalPlacement"))}).func_240699_a_(TextFormatting.WHITE));
            tooltip.add((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.fuzzy_placement", (Object[])new Object[]{Reference.getStateString(compound.func_74767_n("fuzzyPlacement"))}).func_240699_a_(TextFormatting.WHITE));
        }
        if (!KeyHelper.isCtrlKeyDown()) {
            tooltip.add((ITextComponent)StringHelper.getCtrlText((String)"exchangers"));
        }
        if (KeyHelper.isCtrlKeyDown()) {
            tooltip.add((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.extra1", (Object[])new Object[0]).func_240699_a_(TextFormatting.WHITE));
            tooltip.add((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.extra2", (Object[])new Object[0]).func_240699_a_(TextFormatting.WHITE));
            tooltip.add((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.extra3", (Object[])new Object[]{new TranslationTextComponent(Keys.OPEN_GUI_KEY.getKey().toString()).func_240699_a_(TextFormatting.GREEN)}).func_240699_a_(TextFormatting.WHITE));
        }
        if (KeyHelper.isShiftKeyDown()) {
            tooltip.add((ITextComponent)StringHelper.getTierText((String)"exchangers", (int)this.getTier()));
            if (!this.isPowered()) {
                tooltip.add((ITextComponent)StringHelper.formatNumber((long)(stack.func_77958_k() - stack.func_77952_i())).func_240702_b_(" / ").func_230529_a_((ITextComponent)StringHelper.formatNumber((long)stack.func_77958_k())).func_240702_b_(" ").func_230529_a_((ITextComponent)StringHelper.localize((String)"exchangers", (String)"tooltip.durability", (Object[])new Object[0])));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group) && this.checkLoaded()) {
            items.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    @Override
    public boolean checkLoaded() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 20;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185308_t || enchantment == Enchantments.field_185306_r || enchantment == Enchantments.field_185307_s || enchantment == Enchantments.field_185296_A;
    }
}

