/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.handler.mode;

import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.gunpowderlib.helper.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.world.World;

public class ModePlane {
    public static void invoke(Set<BlockPos> coordinates, int range, World world, Direction sideHit, BlockPos pos, BlockState centerState) {
        ArrayList<BlockPos> possibleLocs = new ArrayList<BlockPos>();
        possibleLocs.add(pos);
        int index = 0;
        do {
            BlockPos currentPos = (BlockPos)possibleLocs.get(index);
            ExchangerHandler.checkAndAddBlock(world, currentPos, centerState, coordinates);
            switch (sideHit) {
                case UP: {
                    ModePlane.getConnectedBlocksUD(possibleLocs, world, currentPos, pos, centerState, range, true);
                    break;
                }
                case DOWN: {
                    ModePlane.getConnectedBlocksUD(possibleLocs, world, currentPos, pos, centerState, range, false);
                    break;
                }
                case SOUTH: {
                    ModePlane.getConnectedBlocksNS(possibleLocs, world, currentPos, pos, centerState, range, true);
                    break;
                }
                case NORTH: {
                    ModePlane.getConnectedBlocksNS(possibleLocs, world, currentPos, pos, centerState, range, false);
                    break;
                }
                case EAST: {
                    ModePlane.getConnectedBlocksEW(possibleLocs, world, currentPos, pos, centerState, range, true);
                    break;
                }
                case WEST: {
                    ModePlane.getConnectedBlocksEW(possibleLocs, world, currentPos, pos, centerState, range, false);
                }
            }
        } while (++index < possibleLocs.size());
    }

    public static IFormattableTextComponent getDisplayName() {
        return StringHelper.localize((String)"exchangers", (String)"mode.plane", (Object[])new Object[0]);
    }

    private static void getConnectedBlocksUD(List<BlockPos> possibleLocs, World world, BlockPos currentPos, BlockPos centerPos, BlockState centerState, int range, boolean side) {
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                BlockPos newPos = currentPos.func_177982_a(x, 0, y);
                if (ModePlane.isLocationContained(possibleLocs, newPos) || newPos.func_177958_n() > centerPos.func_177958_n() + range || newPos.func_177958_n() < centerPos.func_177958_n() - range || newPos.func_177952_p() > centerPos.func_177952_p() + range || newPos.func_177952_p() < centerPos.func_177952_p() - range || world.func_180495_p(newPos.func_177982_a(0, side ? 1 : -1, 0)).func_200132_m() || !ModePlane.checkBlock(world, newPos, centerState)) continue;
                possibleLocs.add(newPos);
            }
        }
    }

    private static void getConnectedBlocksNS(List<BlockPos> possibleLocs, World world, BlockPos currentPos, BlockPos centerPos, BlockState centerState, int range, boolean side) {
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                BlockPos newPos = currentPos.func_177982_a(x, y, 0);
                if (ModePlane.isLocationContained(possibleLocs, newPos) || newPos.func_177958_n() > centerPos.func_177958_n() + range || newPos.func_177958_n() < centerPos.func_177958_n() - range || newPos.func_177956_o() > centerPos.func_177956_o() + range || newPos.func_177956_o() < centerPos.func_177956_o() - range || world.func_180495_p(newPos.func_177982_a(0, 0, side ? 1 : -1)).func_200132_m() || !ModePlane.checkBlock(world, newPos, centerState)) continue;
                possibleLocs.add(newPos);
            }
        }
    }

    private static void getConnectedBlocksEW(List<BlockPos> possibleLocs, World world, BlockPos currentPos, BlockPos centerPos, BlockState centerState, int range, boolean side) {
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                BlockPos newPos = currentPos.func_177982_a(0, x, y);
                if (ModePlane.isLocationContained(possibleLocs, newPos) || newPos.func_177956_o() > centerPos.func_177956_o() + range || newPos.func_177956_o() < centerPos.func_177956_o() - range || newPos.func_177952_p() > centerPos.func_177952_p() + range || newPos.func_177952_p() < centerPos.func_177952_p() - range || world.func_180495_p(newPos.func_177982_a(side ? 1 : -1, 0, 0)).func_200132_m() || !ModePlane.checkBlock(world, newPos, centerState)) continue;
                possibleLocs.add(newPos);
            }
        }
    }

    private static boolean isLocationContained(List<BlockPos> possibleLocs, BlockPos toFind) {
        for (BlockPos pos : possibleLocs) {
            if (pos.func_177958_n() != toFind.func_177958_n() || pos.func_177956_o() != toFind.func_177956_o() || pos.func_177952_p() != toFind.func_177952_p()) continue;
            return true;
        }
        return false;
    }

    private static boolean checkBlock(World world, BlockPos pos, BlockState centerState) {
        BlockState state = world.func_180495_p(pos);
        return state == centerState;
    }
}

