/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.handler;

import jackyy.exchangers.handler.ItemHandler;
import jackyy.exchangers.handler.mode.ModeHorizontalCol;
import jackyy.exchangers.handler.mode.ModePlane;
import jackyy.exchangers.handler.mode.ModeVerticalCol;
import jackyy.exchangers.item.ItemExchangerBase;
import jackyy.exchangers.registry.ModConfigs;
import jackyy.gunpowderlib.helper.ChatHelper;
import jackyy.gunpowderlib.helper.NBTHelper;
import jackyy.gunpowderlib.helper.StringHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class ExchangerHandler {
    public static final String[] rangeList = new String[]{"1x1", "3x3", "5x5", "7x7", "9x9", "11x11", "13x13", "15x15", "17x17", "19x19", "21x21", "23x23", "25x25"};

    public static void setDefaultTagCompound(ItemStack stack) {
        Set keySet;
        if (!stack.func_77942_o()) {
            CompoundNBT compound = new CompoundNBT();
            stack.func_77982_d(compound);
        }
        if (!(keySet = NBTHelper.getTag((ItemStack)stack).func_150296_c()).contains("blockstate")) {
            NBTHelper.getTag((ItemStack)stack).func_218657_a("blockstate", (INBT)NBTUtil.func_190009_a((BlockState)Blocks.field_150350_a.func_176223_P()));
        }
        if (!keySet.contains("mode")) {
            NBTHelper.getTag((ItemStack)stack).func_74768_a("mode", 0);
        }
        if (!keySet.contains("range")) {
            NBTHelper.getTag((ItemStack)stack).func_74768_a("range", 0);
        }
        if (!keySet.contains("forceDropItems")) {
            NBTHelper.getTag((ItemStack)stack).func_74757_a("forceDropItems", false);
        }
        if (!keySet.contains("directionalPlacement")) {
            NBTHelper.getTag((ItemStack)stack).func_74757_a("directionalPlacement", false);
        }
        if (!keySet.contains("fuzzyPlacement")) {
            NBTHelper.getTag((ItemStack)stack).func_74757_a("fuzzyPlacement", false);
        }
        if (!keySet.contains("fuzzyPlacementChance")) {
            NBTHelper.getTag((ItemStack)stack).func_74768_a("fuzzyPlacementChance", 100);
        }
        if (!keySet.contains("voidItems")) {
            NBTHelper.getTag((ItemStack)stack).func_74757_a("voidItems", false);
        }
    }

    public static int getExPerBlockUse(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).getPerBlockUse();
    }

    public static int getPerBlockEnergy(ItemStack stack) {
        int level;
        if (((Boolean)ModConfigs.CONFIG.unbreakingPoweredExchangers.get()).booleanValue() && new Random().nextInt(2 + (level = MathHelper.func_76125_a((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack), (int)0, (int)10))) >= 2) {
            return 0;
        }
        return ExchangerHandler.getExPerBlockUse(stack);
    }

    public static int getExHarvestLevel(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).getHarvestLevel();
    }

    public static int getExRange(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).getMaxRange();
    }

    public static boolean getExIsCreative(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).isCreative();
    }

    public static boolean getExIsPowered(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).isPowered();
    }

    public static void switchRange(ItemStack stack, boolean decrease) {
        ExchangerHandler.setDefaultTagCompound(stack);
        int rangeSwitch = NBTHelper.getTag((ItemStack)stack).func_74762_e("range");
        rangeSwitch = decrease ? --rangeSwitch : ++rangeSwitch;
        if (!stack.func_190926_b()) {
            if (rangeSwitch > ExchangerHandler.getExRange(stack)) {
                rangeSwitch = 0;
            } else if (rangeSwitch < 0) {
                rangeSwitch = ExchangerHandler.getExRange(stack);
            }
        }
        NBTHelper.getTag((ItemStack)stack).func_74768_a("range", rangeSwitch);
    }

    public static void switchMode(PlayerEntity player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        int mode = NBTHelper.getTag((ItemStack)stack).func_74762_e("mode");
        mode = player.func_225608_bj_() ? --mode : ++mode;
        if (!stack.func_190926_b()) {
            if (mode > 2) {
                mode = 0;
            } else if (mode < 0) {
                mode = 2;
            }
        }
        NBTHelper.getTag((ItemStack)stack).func_74768_a("mode", mode);
        switch (mode) {
            case 0: {
                ChatHelper.msgPlayerRaw((PlayerEntity)player, (IFormattableTextComponent)StringHelper.localize((String)"exchangers", (String)"msg.mode", (Object[])new Object[]{ModePlane.getDisplayName().func_240699_a_(TextFormatting.GREEN)}));
                break;
            }
            case 1: {
                ChatHelper.msgPlayerRaw((PlayerEntity)player, (IFormattableTextComponent)StringHelper.localize((String)"exchangers", (String)"msg.mode", (Object[])new Object[]{ModeHorizontalCol.getDisplayName().func_240699_a_(TextFormatting.GREEN)}));
                break;
            }
            case 2: {
                ChatHelper.msgPlayerRaw((PlayerEntity)player, (IFormattableTextComponent)StringHelper.localize((String)"exchangers", (String)"msg.mode", (Object[])new Object[]{ModeVerticalCol.getDisplayName().func_240699_a_(TextFormatting.GREEN)}));
            }
        }
    }

    public static void toggleForceDropItems(PlayerEntity player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        boolean toggle = NBTHelper.getTag((ItemStack)stack).func_74767_n("forceDropItems");
        if (!stack.func_190926_b()) {
            toggle = !toggle;
        }
        NBTHelper.getTag((ItemStack)stack).func_74757_a("forceDropItems", toggle);
        ChatHelper.msgPlayer((PlayerEntity)player, (String)"exchangers", (String)(toggle ? "msg.force_drop_items.on" : "msg.force_drop_items.off"));
    }

    public static void toggleDirectionalPlacement(PlayerEntity player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        boolean toggle = NBTHelper.getTag((ItemStack)stack).func_74767_n("directionalPlacement");
        if (!stack.func_190926_b()) {
            toggle = !toggle;
        }
        NBTHelper.getTag((ItemStack)stack).func_74757_a("directionalPlacement", toggle);
        ChatHelper.msgPlayer((PlayerEntity)player, (String)"exchangers", (String)(toggle ? "msg.directional_placement.on" : "msg.directional_placement.off"));
    }

    public static void toggleFuzzyPlacement(PlayerEntity player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        boolean toggle = NBTHelper.getTag((ItemStack)stack).func_74767_n("fuzzyPlacement");
        if (!stack.func_190926_b()) {
            toggle = !toggle;
        }
        NBTHelper.getTag((ItemStack)stack).func_74757_a("fuzzyPlacement", toggle);
        ChatHelper.msgPlayer((PlayerEntity)player, (String)"exchangers", (String)(toggle ? "msg.fuzzy_placement.on" : "msg.fuzzy_placement.off"));
    }

    public static void setFuzzyPlacementChance(ItemStack stack, int chance) {
        ExchangerHandler.setDefaultTagCompound(stack);
        int currentChance = NBTHelper.getTag((ItemStack)stack).func_74762_e("fuzzyPlacementChance");
        if (!stack.func_190926_b()) {
            currentChance = chance;
        }
        NBTHelper.getTag((ItemStack)stack).func_74768_a("fuzzyPlacementChance", currentChance);
    }

    public static void toggleVoidItems(PlayerEntity player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        boolean toggle = NBTHelper.getTag((ItemStack)stack).func_74767_n("voidItems");
        if (!stack.func_190926_b()) {
            toggle = !toggle;
        }
        NBTHelper.getTag((ItemStack)stack).func_74757_a("voidItems", toggle);
        ChatHelper.msgPlayer((PlayerEntity)player, (String)"exchangers", (String)(toggle ? "msg.void_items.on" : "msg.void_items.off"));
    }

    public static boolean isWhitelisted(World world, BlockPos pos) {
        for (String block : ((String)ModConfigs.CONFIG.blocksWhitelist.get()).trim().split(";")) {
            if (!world.func_180495_p(pos).func_177230_c().getRegistryName().equals((Object)new ResourceLocation(block))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlacklisted(World world, BlockPos pos) {
        for (String block : ((String)ModConfigs.CONFIG.blocksBlacklist.get()).trim().split(";")) {
            if (!world.func_180495_p(pos).func_177230_c().getRegistryName().equals((Object)new ResourceLocation(block))) continue;
            return true;
        }
        return false;
    }

    public static void placeBlock(ItemStack stack, PlayerEntity player, World world, BlockPos pos, Direction side, ItemUseContext context) {
        CompoundNBT tag = NBTHelper.getTag((ItemStack)stack);
        BlockState state = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("blockstate"));
        Block block = state.func_177230_c();
        BlockState oldState = world.func_180495_p(pos);
        Block oldblock = oldState.func_177230_c();
        float blockHardness = oldState.func_185887_b((IBlockReader)world, pos);
        if (block == Blocks.field_150350_a) {
            return;
        }
        if (block == oldblock && state == oldState) {
            return;
        }
        if (world.func_175625_s(pos) != null && !ExchangerHandler.isWhitelisted(world, pos)) {
            ChatHelper.msgPlayer((PlayerEntity)player, (String)"exchangers", (String)"error.invalid_block.te");
            return;
        }
        if (ExchangerHandler.isBlacklisted(world, pos)) {
            ChatHelper.msgPlayer((PlayerEntity)player, (String)"exchangers", (String)"error.blacklisted");
            return;
        }
        if (!ExchangerHandler.getExIsCreative(stack) && blockHardness < -0.1f) {
            ChatHelper.msgPlayer((PlayerEntity)player, (String)"exchangers", (String)"error.invalid_block.unbreakable");
            return;
        }
        if (!ExchangerHandler.getExIsCreative(stack) && ExchangerHandler.getExIsPowered(stack) && NBTHelper.getTag((ItemStack)stack).func_74762_e("Energy") < ExchangerHandler.getPerBlockEnergy(stack)) {
            ChatHelper.msgPlayer((PlayerEntity)player, (String)"exchangers", (String)"error.out_of_power");
            return;
        }
        if (!ExchangerHandler.getExIsCreative(stack) && ExchangerHandler.getExHarvestLevel(stack) < oldblock.getHarvestLevel(oldState)) {
            ChatHelper.msgPlayer((PlayerEntity)player, (String)"exchangers", (String)"error.low_harvest_level");
            return;
        }
        Set<BlockPos> suitableBlocks = ExchangerHandler.findSuitableBlocks(stack, world, player, side, pos, oldState);
        Set<Object> toBePlaced = new HashSet();
        boolean notEnough = false;
        world.captureBlockSnapshots = false;
        for (BlockPos blockPos : suitableBlocks) {
            if (tag.func_74767_n("fuzzyPlacement")) {
                if (new Random().nextInt(100) >= tag.func_74762_e("fuzzyPlacementChance")) continue;
                toBePlaced.add(blockPos);
                continue;
            }
            toBePlaced = suitableBlocks;
        }
        for (BlockPos blockPos : toBePlaced) {
            BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)blockPos, (int)3), Blocks.field_150350_a.func_176223_P(), (Entity)player);
            if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
            }
            if (!tag.func_74767_n("directionalPlacement")) {
                world.func_180501_a(blockPos, state, 3);
            }
            if (tag.func_74767_n("directionalPlacement")) {
                BlockState placeState = block.func_196258_a(new BlockItemUseContext(context));
                if (placeState != null) {
                    world.func_180501_a(blockPos, placeState, 3);
                } else {
                    world.func_180501_a(blockPos, state, 3);
                }
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                if (ItemHandler.consumeItemInInventory(block.func_199767_j(), player.field_71071_by, player)) {
                    if (!(player.func_184812_l_() || ExchangerHandler.getExIsCreative(stack) || tag.func_74767_n("voidItems"))) {
                        if (((Boolean)ModConfigs.CONFIG.doExchangersSilkTouch.get()).booleanValue() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
                            ItemStack oldblockItem = !(oldblock instanceof IForgeShearable) ? ItemHandler.getSilkTouchDrop(oldState) : oldblock.getPickBlock(oldState, null, (IBlockReader)world, pos, player);
                            if (oldblockItem.func_77973_b().equals(Items.field_190931_a)) {
                                oldblockItem = oldblock.getPickBlock(oldState, null, (IBlockReader)world, pos, player);
                            }
                            ItemHandler.giveItem(world, player, oldblockItem);
                        } else {
                            ServerWorld serverWorld = (ServerWorld)world;
                            ToolType harvestTool = oldState.getHarvestTool();
                            ItemStack tool = harvestTool == ToolType.PICKAXE ? new ItemStack((IItemProvider)Items.field_234756_kK_) : (harvestTool == ToolType.AXE ? new ItemStack((IItemProvider)Items.field_234757_kL_) : (harvestTool == ToolType.SHOVEL ? new ItemStack((IItemProvider)Items.field_234755_kJ_) : new ItemStack((IItemProvider)Items.field_151055_y)));
                            int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
                            tool.func_77966_a(Enchantments.field_185308_t, fortuneLevel);
                            LootContext.Builder builder = new LootContext.Builder(serverWorld).func_216023_a(serverWorld.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)tool);
                            List oldblockItems = oldState.func_215693_a(builder);
                            for (ItemStack oldblockItem : oldblockItems) {
                                ItemHandler.giveItem(world, player, oldblockItem);
                            }
                        }
                        if (!ExchangerHandler.getExIsPowered(stack)) {
                            stack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
                        } else if (tag.func_74762_e("Energy") >= ExchangerHandler.getPerBlockEnergy(stack)) {
                            tag.func_74768_a("Energy", tag.func_74762_e("Energy") - ExchangerHandler.getPerBlockEnergy(stack));
                        }
                        player.field_71070_bA.func_75142_b();
                    }
                    world.func_184148_a(null, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.1f, 1.0f);
                    continue;
                }
                world.restoringBlockSnapshots = true;
                event.getBlockSnapshot().restore(true);
                world.restoringBlockSnapshots = false;
                notEnough = true;
                continue;
            }
            world.restoringBlockSnapshots = true;
            event.getBlockSnapshot().restore(true);
            world.restoringBlockSnapshots = false;
            ChatHelper.msgPlayer((PlayerEntity)player, (String)"exchangers", (String)"error.event_cancelled");
        }
        if (notEnough) {
            ChatHelper.msgPlayer((PlayerEntity)player, (String)"exchangers", (String)"error.out_of_block");
        }
        world.captureBlockSnapshots = true;
    }

    public static void selectBlock(ItemStack stack, PlayerEntity player, World world, BlockPos pos) {
        ExchangerHandler.setDefaultTagCompound(stack);
        BlockState state = world.func_180495_p(pos);
        float blockHardness = state.func_185887_b((IBlockReader)world, pos);
        if (world.func_175625_s(pos) != null && !ExchangerHandler.isWhitelisted(world, pos)) {
            ChatHelper.msgPlayer((PlayerEntity)player, (String)"exchangers", (String)"error.invalid_block.te");
            return;
        }
        if (ExchangerHandler.isBlacklisted(world, pos)) {
            ChatHelper.msgPlayer((PlayerEntity)player, (String)"exchangers", (String)"error.blacklisted");
            return;
        }
        if (!ExchangerHandler.getExIsCreative(stack) && blockHardness < -0.1f) {
            ChatHelper.msgPlayer((PlayerEntity)player, (String)"exchangers", (String)"error.invalid_block.unbreakable");
            return;
        }
        NBTHelper.getTag((ItemStack)stack).func_218657_a("blockstate", (INBT)NBTUtil.func_190009_a((BlockState)state));
    }

    public static Set<BlockPos> findSuitableBlocks(ItemStack stack, World world, PlayerEntity player, Direction sideHit, BlockPos pos, BlockState centerState) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        int range = NBTHelper.getTag((ItemStack)stack).func_74762_e("range");
        int mode = NBTHelper.getTag((ItemStack)stack).func_74762_e("mode");
        switch (mode) {
            case 0: {
                ModePlane.invoke(coordinates, range, world, sideHit, pos, centerState);
                break;
            }
            case 1: {
                ModeHorizontalCol.invoke(coordinates, range, world, player, sideHit, pos, centerState);
                break;
            }
            case 2: {
                ModeVerticalCol.invoke(coordinates, range, world, player, sideHit, pos, centerState);
            }
        }
        return coordinates;
    }

    public static void checkAndAddBlock(World world, BlockPos pos, BlockState centerState, Set<BlockPos> coordinates) {
        BlockState state = world.func_180495_p(pos);
        if (state == centerState) {
            coordinates.add(pos);
        }
    }

    public static IFormattableTextComponent getBlockName(Block block) {
        ItemStack stack = new ItemStack((IItemProvider)block, 1);
        try {
            IFormattableTextComponent name = stack.func_200301_q().func_230531_f_();
            return name;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return new StringTextComponent("Unable to fetch block name.");
        }
    }
}

