/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import java.util.zip.Inflater;
import net.minecraft.network.NettyCompressionDecoder;
import net.minecraft.network.PacketBuffer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={NettyCompressionDecoder.class}, priority=99)
public abstract class NettyCompressionDecoderMixin
extends ByteToMessageDecoder {
    @Shadow
    private int field_179304_b;
    @Shadow
    @Final
    private Inflater field_179305_a;

    @Overwrite
    public void decode(ChannelHandlerContext context, ByteBuf byteBuf, List<Object> decoded) throws Exception {
        if (byteBuf.readableBytes() != 0) {
            PacketBuffer packetbuffer = new PacketBuffer(byteBuf);
            int i = packetbuffer.func_150792_a();
            if (i == 0) {
                decoded.add(packetbuffer.readBytes(packetbuffer.readableBytes()));
            } else {
                byte[] abyte = new byte[packetbuffer.readableBytes()];
                packetbuffer.readBytes(abyte);
                this.field_179305_a.setInput(abyte);
                byte[] abyte1 = new byte[i];
                this.field_179305_a.inflate(abyte1);
                decoded.add(Unpooled.wrappedBuffer((byte[])abyte1));
                this.field_179305_a.reset();
                if (i < this.field_179304_b) {
                    this.printDebug(decoded);
                    if (!((Boolean)Connectivity.config.getCommonConfig().disablePacketLimits.get()).booleanValue()) {
                        throw new DecoderException("Badly compressed packet - size of " + i + " is below server threshold of " + this.field_179304_b);
                    }
                }
                if (i > 0x200000) {
                    this.printDebug(decoded);
                    if (!((Boolean)Connectivity.config.getCommonConfig().disablePacketLimits.get()).booleanValue()) {
                        throw new DecoderException("Badly compressed packet - size of " + i + " is larger than protocol maximum of " + 0x200000);
                    }
                }
            }
        }
    }

    private void printDebug(List<Object> decodingResults) {
        if (!((Boolean)Connectivity.config.getCommonConfig().debugPrintMessages.get()).booleanValue()) {
            return;
        }
        Connectivity.LOGGER.error("Received too large message, debug print below!");
        Connectivity.LOGGER.error("----BEGIND PRINTING PACKET-----");
        for (int i = 0; i < decodingResults.size(); ++i) {
            ByteBuf buf = (ByteBuf)decodingResults.get(i);
            if (buf == null) continue;
            Connectivity.LOGGER.error("Data:");
            Connectivity.LOGGER.error(buf.toString(Charsets.UTF_8));
        }
        Connectivity.LOGGER.error("----END PRINTING PACKET-----");
    }
}

