/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.mixin.common.world.layers;

import corgiaoc.byg.BYG;
import corgiaoc.byg.common.world.biome.BYGBiome;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.ShoreLayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShoreLayer.class})
public abstract class MixinShoreLayer {
    private static final int WARM_OCEAN = WorldGenRegistries.field_243657_i.func_148757_b(WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_203614_T));
    private static final int LUKEWARM_OCEAN = WorldGenRegistries.field_243657_i.func_148757_b(WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_203615_U));
    private static final int OCEAN = WorldGenRegistries.field_243657_i.func_148757_b(WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_76771_b));
    private static final int COLD_OCEAN = WorldGenRegistries.field_243657_i.func_148757_b(WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_203616_V));
    private static final int FROZEN_OCEAN = WorldGenRegistries.field_243657_i.func_148757_b(WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_76776_l));
    private static final int DEEP_WARM_OCEAN = WorldGenRegistries.field_243657_i.func_148757_b(WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_203617_W));
    private static final int DEEP_LUKEWARM_OCEAN = WorldGenRegistries.field_243657_i.func_148757_b(WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_203618_X));
    private static final int DEEP_OCEAN = WorldGenRegistries.field_243657_i.func_148757_b(WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_150575_M));
    private static final int DEEP_COLD_OCEAN = WorldGenRegistries.field_243657_i.func_148757_b(WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_203619_Y));
    private static final int DEEP_FROZEN_OCEAN = WorldGenRegistries.field_243657_i.func_148757_b(WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_203620_Z));

    @Inject(at={@At(value="HEAD")}, method={"apply(Lnet/minecraft/world/gen/INoiseRandom;IIIII)I"}, cancellable=true)
    private void injectBYGEdges(INoiseRandom rand, int n, int w, int s, int e, int c, CallbackInfoReturnable<Integer> cir) {
        int[] ArrayNESW = new int[]{n, w, s, e};
        ResourceLocation centre = BYG.biomeRegistryAccess.func_177774_c(BYG.biomeRegistryAccess.func_148745_a(c));
        for (int idx : ArrayNESW) {
            int id;
            if (BYGBiome.BIOME_TO_EDGE_LIST.containsKey(centre) && !MixinShoreLayer.isEdgeCompatible(idx)) {
                id = BYG.biomeRegistryAccess.func_148757_b(BYG.biomeRegistryAccess.func_82594_a(BYGBiome.BIOME_TO_EDGE_LIST.get(centre)));
                cir.setReturnValue((Object)id);
                return;
            }
            if (!BYGBiome.BIOME_TO_BEACH_LIST.containsKey(centre) || !MixinShoreLayer.isOcean(idx)) continue;
            id = BYG.biomeRegistryAccess.func_148757_b(BYG.biomeRegistryAccess.func_82594_a(BYGBiome.BIOME_TO_BEACH_LIST.get(centre)));
            cir.setReturnValue((Object)id);
        }
    }

    private static boolean isEdgeCompatible(int idx) {
        ResourceLocation idxLocation = BYG.biomeRegistryAccess.func_177774_c(BYG.biomeRegistryAccess.func_148745_a(idx));
        return BYGBiome.BIOME_TO_EDGE_LIST.containsKey(idxLocation) || MixinShoreLayer.isOcean(idx);
    }

    private static boolean isOcean(int biome) {
        return biome == WARM_OCEAN || biome == LUKEWARM_OCEAN || biome == OCEAN || biome == COLD_OCEAN || biome == FROZEN_OCEAN || biome == DEEP_WARM_OCEAN || biome == DEEP_LUKEWARM_OCEAN || biome == DEEP_OCEAN || biome == DEEP_COLD_OCEAN || biome == DEEP_FROZEN_OCEAN;
    }
}

