/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.core.world.util;

import com.google.common.collect.ImmutableMap;
import corgiaoc.byg.BYG;
import corgiaoc.byg.core.world.BYGBiomes;
import corgiaoc.byg.core.world.BYGDecorators;
import corgiaoc.byg.core.world.BYGFeatures;
import corgiaoc.byg.core.world.BYGStructures;
import corgiaoc.byg.core.world.BYGSurfaceBuilders;
import corgiaoc.byg.mixin.access.DimensionStructuresSettingsAccess;
import corgiaoc.byg.mixin.access.StructureAccess;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;

public class WorldGenRegistrationHelper {
    static Set<Integer> integerList = new HashSet<Integer>();

    public static <SBC extends ISurfaceBuilderConfig, SB extends SurfaceBuilder<SBC>> SB createSurfaceBuilder(String id, SB surfaceBuilder) {
        ResourceLocation bygID = new ResourceLocation("byg", id);
        if (Registry.field_218378_p.func_148742_b().contains(bygID)) {
            throw new IllegalStateException("Surface Builder ID: \"" + bygID.toString() + "\" already exists in the Surface Builder registry!");
        }
        surfaceBuilder.setRegistryName(bygID);
        BYGSurfaceBuilders.surfaceBuilders.add(surfaceBuilder);
        return surfaceBuilder;
    }

    public static <SC extends ISurfaceBuilderConfig, CSB extends ConfiguredSurfaceBuilder<SC>> CSB createConfiguredSurfaceBuilder(String id, CSB configuredSurfaceBuilder) {
        ResourceLocation bygID = new ResourceLocation("byg", id);
        if (WorldGenRegistries.field_243651_c.func_148742_b().contains(bygID)) {
            throw new IllegalStateException("Configured Surface Builder ID: \"" + bygID.toString() + "\" already exists in the Configured Surface Builder registry!");
        }
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243651_c, (ResourceLocation)bygID, configuredSurfaceBuilder);
        return configuredSurfaceBuilder;
    }

    public static <C extends IFeatureConfig, F extends Feature<C>> F createFeature(String id, F feature) {
        ResourceLocation bygID = new ResourceLocation("byg", id);
        if (Registry.field_218379_q.func_148742_b().contains(bygID)) {
            throw new IllegalStateException("Feature ID: \"" + bygID.toString() + "\" already exists in the Features registry!");
        }
        feature.setRegistryName(bygID);
        BYGFeatures.features.add(feature);
        return feature;
    }

    public static <C extends IFeatureConfig, F extends Structure<C>> F createStructure(String id, F structure, int minChunkDistance, int maxChunkDistance, int seedModifier, GenerationStage.Decoration decorationStage) {
        ResourceLocation bygID = new ResourceLocation("byg", id);
        if (Registry.field_218361_B.func_148742_b().contains(bygID)) {
            throw new IllegalStateException("Structure Feature ID: \"" + bygID.toString() + "\" already exists in the Structure Features registry!");
        }
        structure.setRegistryName(bygID);
        BYGStructures.structures.add(structure);
        Structure.field_236365_a_.put((Object)bygID.toString(), structure);
        StructureAccess.getStructureStep().put(structure, decorationStage);
        DimensionStructuresSettingsAccess.setDefaults(ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)new StructureSeparationSettings(minChunkDistance, maxChunkDistance, seedModifier)).build());
        return structure;
    }

    public static <C extends IFeatureConfig, CSF extends StructureFeature<C, ?>> CSF createConfiguredStructureFeature(String id, CSF configuredStructureFeature) {
        ResourceLocation bygID = new ResourceLocation("byg", id);
        if (WorldGenRegistries.field_243654_f.func_148742_b().contains(bygID)) {
            throw new IllegalStateException("Configured Structure Feature ID: \"" + bygID.toString() + "\" already exists in the Configured Structure Features registry!");
        }
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)bygID, configuredStructureFeature);
        return configuredStructureFeature;
    }

    public static IStructurePieceType createStructurePiece(String id, IStructurePieceType piece) {
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("byg", id), (Object)piece);
        return piece;
    }

    public static <FC extends IFeatureConfig, F extends Feature<FC>, CF extends ConfiguredFeature<FC, F>> CF createConfiguredFeature(String id, CF configuredFeature) {
        ResourceLocation bygID = new ResourceLocation("byg", id);
        if (WorldGenRegistries.field_243653_e.func_148742_b().contains(bygID)) {
            throw new IllegalStateException("Configured Feature ID: \"" + bygID.toString() + "\" already exists in the Configured Features registry!");
        }
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)bygID, configuredFeature);
        return configuredFeature;
    }

    public static <DC extends IPlacementConfig, D extends Placement<DC>> D createDecorator(String id, D decorator) {
        ResourceLocation bygID = new ResourceLocation("byg", id);
        if (Registry.field_218380_r.func_148742_b().contains(bygID)) {
            throw new IllegalStateException("Decorator ID: \"" + bygID.toString() + "\" already exists in the Decorator registry!");
        }
        decorator.setRegistryName(bygID);
        BYGDecorators.decorators.add(decorator);
        return decorator;
    }

    public static Biome createBiome(String id, Biome biome, int numericalID) {
        ResourceLocation bygID = new ResourceLocation("byg", id);
        if (WorldGenRegistries.field_243657_i.func_148742_b().contains(bygID)) {
            throw new IllegalStateException("Biome ID: \"" + bygID.toString() + "\" already exists in the Biome registry!");
        }
        biome.setRegistryName(bygID);
        if (integerList.contains(numericalID)) {
            BYG.LOGGER.warn("Duplicate Biome Numerical ID: " + numericalID + " at byg:" + id);
        }
        BYGBiomes.biomeList.add(new BYGBiomes.PreserveBiomeOrder(biome, numericalID));
        integerList.add(numericalID);
        return biome;
    }
}

