/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld.river;

import corgiaoc.byg.common.world.feature.overworld.river.MegaChunkPos;
import corgiaoc.byg.common.world.feature.overworld.river.RiverGenerator;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.io.ByteArrayOutputStream;
import java.util.Set;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;

public class MegaChunk {
    private final MegaChunkPos megaChunkPos;
    private final BiomeProvider provider;
    private final ChunkGenerator chunkGenerator;
    private final Set<Biome> allowedBiomes;
    private final byte[] canyonChunks;
    private RiverGenerator riverGenerator;

    public MegaChunk(MegaChunkPos megaChunkPos, ChunkGenerator chunkGenerator, Set<Biome> allowedBiomes) {
        this.megaChunkPos = megaChunkPos;
        this.chunkGenerator = chunkGenerator;
        this.provider = chunkGenerator.func_202090_b();
        this.allowedBiomes = allowedBiomes;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                ChunkPos chunkPos = megaChunkPos.toChunkPos(x, z);
                Biome noiseBiome = chunkGenerator.func_202090_b().func_225526_b_((chunkPos.field_77276_a << 2) + 2, 0, (chunkPos.field_77275_b << 2) + 2);
                if (!allowedBiomes.contains(noiseBiome)) continue;
                byteArrayOutputStream.write(MegaChunkPos.packLocalPos(x, z));
            }
        }
        this.canyonChunks = byteArrayOutputStream.toByteArray();
    }

    public int getCount() {
        return this.canyonChunks.length;
    }

    public MegaChunkPos getMegaChunkPos() {
        return this.megaChunkPos;
    }

    public RiverGenerator getRiverGenerator() {
        return this.riverGenerator;
    }

    public void createRiverGeneratorStart(FastNoise noise, ISeedReader world, long worldSeed, int maxRiverDistance) {
        SharedSeedRandom seedRandom = new SharedSeedRandom(worldSeed);
        seedRandom.func_202426_b(934893458905904595L, this.megaChunkPos.getX(), this.megaChunkPos.getZ());
        byte canyonChunkByte = this.canyonChunks[seedRandom.nextInt(this.canyonChunks.length)];
        BlockPos startPos = this.megaChunkPos.unpackLocalPos(canyonChunkByte).func_206849_h();
        this.riverGenerator = new RiverGenerator(noise, world, new BlockPos(startPos.func_177958_n(), this.chunkGenerator.func_222532_b(startPos.func_177958_n(), startPos.func_177952_p(), Heightmap.Type.OCEAN_FLOOR_WG), startPos.func_177952_p()), this.chunkGenerator, blockpos -> false, blockpos -> {
            Biome.Category category = this.provider.func_225526_b_(blockpos.func_177958_n() >> 2, blockpos.func_177956_o() >> 2, blockpos.func_177952_p() >> 2).func_201856_r();
            return category == Biome.Category.RIVER || category == Biome.Category.OCEAN || this.chunkGenerator.func_222529_a(blockpos.func_177958_n(), blockpos.func_177952_p(), Heightmap.Type.OCEAN_FLOOR_WG) <= this.chunkGenerator.func_230356_f_();
        }, maxRiverDistance);
    }

    public void createRiverGenerator(FastNoise noise, BlockPos generatorStartPos, ISeedReader world, int maxRiverDistance) {
        this.riverGenerator = new RiverGenerator(noise, world, new BlockPos(generatorStartPos.func_177958_n(), 218, generatorStartPos.func_177952_p()), this.chunkGenerator, blockpos -> false, blockpos -> {
            Biome.Category category = this.provider.func_225526_b_(blockpos.func_177958_n() >> 2, blockpos.func_177956_o() >> 2, blockpos.func_177952_p() >> 2).func_201856_r();
            return category == Biome.Category.RIVER || category == Biome.Category.OCEAN || this.chunkGenerator.func_222529_a(blockpos.func_177958_n(), blockpos.func_177952_p(), Heightmap.Type.OCEAN_FLOOR_WG) <= this.chunkGenerator.func_230356_f_();
        }, maxRiverDistance);
    }
}

