/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.nether.spike;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.SimpleBlockProviderConfig;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class SpikeFeature
extends Feature<SimpleBlockProviderConfig> {
    FastNoise fnPerlin = null;

    public SpikeFeature(Codec<SimpleBlockProviderConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, SimpleBlockProviderConfig config) {
        this.setSeed(world.func_72905_C());
        if (world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151579_a || world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151587_i || world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, pos.func_177958_n(), pos.func_177952_p()) < 4) {
            return false;
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        double baseRadius = 4.0;
        int height = 45;
        int startHeight = height - 5;
        for (double y = (double)(-height); y <= -1.0; y += 1.0) {
            for (double x = (double)(-height); x <= (double)height; x += 1.0) {
                for (double z = (double)(-height); z <= (double)height; z += 1.0) {
                    mutable.func_189533_g((Vector3i)pos).func_196234_d((int)x, (int)y + startHeight, (int)z);
                    double noise = this.fnPerlin.GetNoise(mutable.func_177958_n(), mutable.func_177952_p()) * 12.0f;
                    double scaledNoise = noise / 11.0 * (-(y * baseRadius) / (x * x + z * z));
                    double threshold = 0.5;
                    if (y == (double)(-height) && scaledNoise >= threshold && world.func_180495_p(mutable.func_177972_a(Direction.DOWN)).func_185904_a() == Material.field_151579_a) {
                        return false;
                    }
                    if (!(scaledNoise >= threshold) || world.func_180495_p((BlockPos)mutable).func_185904_a() != Material.field_151579_a) continue;
                    BlockState blockState = config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable);
                    world.func_180501_a((BlockPos)mutable, blockState, 2);
                    if (blockState.func_177230_c() != Blocks.field_150353_l) continue;
                    world.func_205219_F_().func_205360_a((BlockPos)mutable, (Object)Fluids.field_204547_b, 0);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.fnPerlin == null) {
            this.fnPerlin = new FastNoise((int)seed);
            this.fnPerlin.SetNoiseType(FastNoise.NoiseType.PerlinFractal);
            this.fnPerlin.SetFractalType(FastNoise.FractalType.FBM);
            this.fnPerlin.SetFrequency(0.2f);
        }
    }
}

