/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class FloatingIslandConfig
implements IFeatureConfig {
    public static final Codec<FloatingIslandConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.field_236796_a_.fieldOf("top_block_provider").forGetter(config -> config.topBlockProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)Codec.INT.fieldOf("min_radius").orElse((Object)13).forGetter(config -> config.minRadius), (App)Codec.INT.fieldOf("max_radius").orElse((Object)15).forGetter(config -> config.maxRadius)).apply((Applicative)codecRecorder, FloatingIslandConfig::new));
    private final BlockStateProvider topBlockProvider;
    private final BlockStateProvider blockProvider;
    private final int minRadius;
    private final int maxRadius;

    FloatingIslandConfig(BlockStateProvider topBlockProvider, BlockStateProvider blockProvider, int minRadius, int maxRadius) {
        this.topBlockProvider = topBlockProvider;
        this.blockProvider = blockProvider;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
    }

    public BlockStateProvider getBlockProvider() {
        return this.blockProvider;
    }

    public BlockStateProvider getTopBlockProvider() {
        return this.topBlockProvider;
    }

    public int getMinRadius() {
        return Math.abs(this.minRadius);
    }

    public int getMaxRadius() {
        return Math.abs(this.maxRadius);
    }

    public int getMaxPossibleRadius() {
        int returnValue = this.maxRadius - this.minRadius;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return Math.abs(returnValue);
    }

    public static class Builder {
        private BlockStateProvider topBlockProvider = new SimpleBlockStateProvider(Blocks.field_196658_i.func_176223_P());
        private BlockStateProvider blockProvider = new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
        private int minRadius = 1;
        private int maxRadius = 3;

        public Builder setTopBlock(Block block) {
            this.topBlockProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setTopBlock(BlockState state) {
            this.topBlockProvider = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setTopBlock(BlockStateProvider provider) {
            this.topBlockProvider = provider != null ? provider : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setBlock(Block block) {
            this.blockProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setBlock(BlockState state) {
            this.blockProvider = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setBlock(BlockStateProvider provider) {
            this.blockProvider = provider != null ? provider : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setMinRadius(int minRadius) {
            this.minRadius = minRadius <= 0 ? 1 : minRadius;
            return this;
        }

        public Builder setMaxRadius(int maxRadius) {
            this.maxRadius = maxRadius <= 0 ? this.minRadius + 1 : maxRadius;
            return this;
        }

        public Builder copy(FloatingIslandConfig config) {
            this.topBlockProvider = config.topBlockProvider;
            this.blockProvider = config.blockProvider;
            this.minRadius = config.minRadius;
            this.maxRadius = config.maxRadius;
            return this;
        }

        public FloatingIslandConfig build() {
            return new FloatingIslandConfig(this.topBlockProvider, this.blockProvider, this.minRadius, this.maxRadius);
        }
    }
}

