/*
 * Decompiled with CFR 0.152.
 */
package tfar.ae2extras;

import appeng.api.config.Actionable;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellInventory;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.me.storage.AbstractCellInventory;
import appeng.me.storage.BasicCellInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class PatchedBasicCellInventory<T extends IAEStack<T>>
extends AbstractCellInventory<T> {
    private final IStorageChannel<T> channel;

    public PatchedBasicCellInventory(IStorageCell<T> cellType, ItemStack o, ISaveProvider container) {
        super(cellType, o, container);
        this.channel = cellType.getChannel();
    }

    private boolean isStorageCell(T input) {
        if (input instanceof IAEItemStack) {
            IAEItemStack stack = (IAEItemStack)input;
            IStorageCell<?> type = PatchedBasicCellInventory.getStorageCell(stack.getDefinition());
            return type != null && !type.storableInStorageCell();
        }
        return false;
    }

    private static IStorageCell<?> getStorageCell(ItemStack input) {
        Item type;
        if (input != null && (type = input.func_77973_b()) instanceof IStorageCell) {
            return (IStorageCell)type;
        }
        return null;
    }

    private static boolean isCellEmpty(ICellInventory inv) {
        if (inv != null) {
            return inv.getAvailableItems(inv.getChannel().createList()).isEmpty();
        }
        return true;
    }

    public T injectItems(T input, Actionable mode, IActionSource src) {
        long remainingItemCount;
        ICellInventory meInventory;
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (this.cellType.isBlackListed(this.getItemStack(), input)) {
            return input;
        }
        if (this.isStorageCell(input) && !PatchedBasicCellInventory.isCellEmpty(meInventory = BasicCellInventory.createInventory((ItemStack)((IAEItemStack)input).createItemStack(), null))) {
            return input;
        }
        IAEStack l = this.getCellItems().findPrecise(input);
        if (l != null) {
            long remainingItemCount2 = this.getRemainingItemCount();
            if (remainingItemCount2 <= 0L) {
                return input;
            }
            if (input.getStackSize() > remainingItemCount2) {
                IAEStack r = input.copy();
                r.setStackSize(r.getStackSize() - remainingItemCount2);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() + remainingItemCount2);
                    this.saveChanges();
                }
                return (T)r;
            }
            if (mode == Actionable.MODULATE) {
                l.setStackSize(l.getStackSize() + input.getStackSize());
                this.saveChanges();
            }
            return null;
        }
        if (this.canHoldNewItem() && (remainingItemCount = this.getRemainingItemCount() - (long)(this.getBytesPerType() * this.itemsPerByte)) > 0L) {
            if (input.getStackSize() > remainingItemCount) {
                IAEStack toReturn = input.copy();
                toReturn.setStackSize(input.getStackSize() - remainingItemCount);
                if (mode == Actionable.MODULATE) {
                    IAEStack toWrite = input.copy();
                    toWrite.setStackSize(remainingItemCount);
                    this.cellItems.add(toWrite);
                    this.saveChanges();
                }
                return (T)toReturn;
            }
            if (mode == Actionable.MODULATE) {
                this.cellItems.add(input);
                this.saveChanges();
            }
            return null;
        }
        return input;
    }

    public T extractItems(T request, Actionable mode, IActionSource src) {
        if (request == null) {
            return null;
        }
        long size = Math.min(Integer.MAX_VALUE, request.getStackSize());
        IAEStack Results = null;
        IAEStack l = this.getCellItems().findPrecise(request);
        if (l != null) {
            Results = l.copy();
            if (l.getStackSize() <= size) {
                Results.setStackSize(l.getStackSize());
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(0L);
                    this.saveChanges();
                }
            } else {
                Results.setStackSize(size);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() - size);
                    this.saveChanges();
                }
            }
        }
        return (T)Results;
    }

    public IStorageChannel<T> getChannel() {
        return this.channel;
    }

    protected boolean loadCellItem(CompoundNBT compoundTag, int stackSize) {
        IAEStack t;
        try {
            t = this.getChannel().createFromNBT(compoundTag);
            if (t == null) {
                AELog.warn((String)("Removing item " + compoundTag + " from storage cell because the associated item type couldn't be found."), (Object[])new Object[0]);
                return false;
            }
        }
        catch (Throwable ex) {
            if (AEConfig.instance().isRemoveCrashingItemsOnLoad()) {
                AELog.warn((Throwable)ex, (String)("Removing item " + compoundTag + " from storage cell because loading the ItemStack crashed."));
                return false;
            }
            throw ex;
        }
        t.setStackSize((long)stackSize);
        if (stackSize > 0) {
            this.cellItems.add(t);
        }
        return true;
    }
}

