/*
 * Decompiled with CFR 0.152.
 */
package tfar.ae2extras;

import appeng.api.definitions.IDefinitions;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import tfar.ae2extras.CraftingStorageBlockEx;

public final class DisassembleRecipe
extends ShapelessRecipe {
    public static final IRecipeSerializer<ShapelessRecipe> SERIALIZER = new Serializer2();
    private static final ItemStack MISMATCHED_STACK = ItemStack.field_190927_a;

    public DisassembleRecipe(ShapelessRecipe recipe) {
        super(recipe.func_199560_c(), recipe.func_193358_e(), recipe.func_77571_b(), recipe.func_192400_c());
    }

    public boolean func_77569_a(@Nonnull CraftingInventory inv, @Nonnull World w) {
        return super.func_77569_a(inv, w) && this.isCellEmpty(inv, w);
    }

    public boolean isCellEmpty(@Nonnull CraftingInventory inv, @Nonnull World w) {
        int itemCount = 0;
        for (int slotIndex = 0; slotIndex < inv.func_70302_i_(); ++slotIndex) {
            IItemList list;
            ItemStack storageCell = inv.func_70301_a(slotIndex);
            if (storageCell.func_190926_b()) continue;
            if (++itemCount > 1) {
                return false;
            }
            ICellInventoryHandler cellInv = Api.instance().registries().cell().getCellInventory(storageCell, null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
            if (cellInv == null || (list = cellInv.getAvailableItems(((IItemStorageChannel)Api.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList())).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (!(Block.func_149634_a((Item)item.func_77973_b()) instanceof CraftingStorageBlockEx)) continue;
            IDefinitions definitions = Api.instance().definitions();
            nonnulllist.set(i, (Object)definitions.blocks().craftingUnit().stack(1));
        }
        return nonnulllist;
    }

    @Nonnull
    public IRecipeSerializer<ShapelessRecipe> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer2
    extends ShapelessRecipe.Serializer {
        public ShapelessRecipe func_199425_a_(ResourceLocation recipeId, JsonObject json) {
            return new DisassembleRecipe(super.func_199425_a_(recipeId, json));
        }

        public ShapelessRecipe func_199426_a_(ResourceLocation recipeId, PacketBuffer buffer) {
            return new DisassembleRecipe(super.func_199426_a_(recipeId, buffer));
        }
    }
}

