/*
 * Decompiled with CFR 0.152.
 */
package tfar.ae2extras;

import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import appeng.items.storage.AbstractStorageCell;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class AdvancedStorageCellItem
extends AbstractStorageCell<IAEItemStack> {
    protected final int perType;
    protected final double idleDrain;
    private final Supplier<Item> itemSupplier;

    public AdvancedStorageCellItem(Item.Properties properties, int kilobytes, double idleDrain, Supplier<Item> itemSupplier) {
        super(properties, null, kilobytes);
        this.perType = kilobytes * 8;
        this.idleDrain = idleDrain;
        this.itemSupplier = itemSupplier;
    }

    public double getIdleDrain() {
        return this.idleDrain;
    }

    @Nonnull
    public IStorageChannel<IAEItemStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    public int getBytesPerType(@Nonnull ItemStack itemStack) {
        return this.perType;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        this.disassembleDrive(player.func_184586_b(hand), world, player);
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private boolean disassembleDrive(ItemStack stack, World world, PlayerEntity player) {
        if (player.func_213453_ef()) {
            if (Platform.isClient()) {
                return false;
            }
            PlayerInventory playerInventory = player.field_71071_by;
            ICellInventoryHandler inv = Api.instance().registries().cell().getCellInventory(stack, null, this.getChannel());
            if (inv != null && playerInventory.func_70448_g() == stack) {
                InventoryAdaptor ia = InventoryAdaptor.getAdaptor((PlayerEntity)player);
                IItemList list = inv.getAvailableItems(this.getChannel().createList());
                if (list.isEmpty() && ia != null) {
                    playerInventory.func_70299_a(playerInventory.field_70461_c, ItemStack.field_190927_a);
                    ItemStack extraB = ia.addItems(this.getCellComponent());
                    if (!extraB.func_190926_b()) {
                        player.func_71019_a(extraB, false);
                    }
                    IItemHandler upgradesInventory = this.getUpgradesInventory(stack);
                    for (int upgradeIndex = 0; upgradeIndex < upgradesInventory.getSlots(); ++upgradeIndex) {
                        ItemStack upgradeStack = upgradesInventory.getStackInSlot(upgradeIndex);
                        ItemStack leftStack = ia.addItems(upgradeStack);
                        if (leftStack.func_190926_b() || !(upgradeStack.func_77973_b() instanceof IUpgradeModule)) continue;
                        player.func_71019_a(upgradeStack, false);
                    }
                    this.dropEmptyStorageCellCase(ia, player);
                    if (player.field_71069_bz != null) {
                        player.field_71069_bz.func_75142_b();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return this.disassembleDrive(stack, context.func_195991_k(), context.func_195999_j()) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public ItemStack getCellComponent() {
        return new ItemStack((IItemProvider)this.itemSupplier.get());
    }

    protected void dropEmptyStorageCellCase(InventoryAdaptor ia, PlayerEntity player) {
        Api.instance().definitions().materials().emptyStorageCell().maybeStack(1).ifPresent(is -> {
            ItemStack extraA = ia.addItems(is);
            if (!extraA.func_190926_b()) {
                player.func_71019_a(extraA, false);
            }
        });
    }
}

