/*
 * Decompiled with CFR 0.152.
 */
package tfar.ae2extras;

import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.block.crafting.CraftingStorageItem;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tfar.ae2extras.AdvancedFluidStorageCellItem;
import tfar.ae2extras.AdvancedStorageCellItem;
import tfar.ae2extras.CraftingStorageBlockEx;
import tfar.ae2extras.DisassembleRecipe;

@Mod(value="ae2extras")
public class AE2Extras {
    public static final String MODID = "ae2extras";
    public static AbstractCraftingUnitBlock.CraftingUnitType STORAGE_256K;
    public static AbstractCraftingUnitBlock.CraftingUnitType STORAGE_1M;
    public static AbstractCraftingUnitBlock.CraftingUnitType STORAGE_4M;
    public static AbstractCraftingUnitBlock.CraftingUnitType STORAGE_16M;
    public static Block STORAGE256K;
    public static Block STORAGE1M;
    public static Block STORAGE4M;
    public static Block STORAGE16M;
    public static final ItemGroup TAB;
    static Item.Properties props;
    static Item.Properties props_nostack;
    public static Item CELL_COMPONENT_256K;
    public static Item ITEM_CELL_256K;
    public static Item CELL_COMPONENT_1M;
    public static Item ITEM_CELL_1M;
    public static Item CELL_COMPONENT_4M;
    public static Item ITEM_CELL_4M;
    public static Item CELL_COMPONENT_16M;
    public static Item ITEM_CELL_16M;
    public static Item FLUID_CELL_COMPONENT_256K;
    public static Item FLUID_CELL_256K;
    public static Item FLUID_CELL_COMPONENT_1M;
    public static Item FLUID_CELL_1M;
    public static Item FLUID_CELL_COMPONENT_4M;
    public static Item FLUID_CELL_4M;
    public static Item FLUID_CELL_COMPONENT_16M;
    public static Item FLUID_CELL_16M;

    public AE2Extras() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addGenericListener(Block.class, this::blocks);
        bus.addGenericListener(Item.class, this::items);
        bus.addGenericListener(IRecipeSerializer.class, this::recipes);
        bus.addListener(this::client);
    }

    private void client(FMLClientSetupEvent t) {
        RenderTypeLookup.setRenderLayer((Block)STORAGE256K, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)STORAGE1M, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)STORAGE4M, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)STORAGE16M, (RenderType)RenderType.func_228643_e_());
    }

    private void blocks(RegistryEvent.Register<Block> event) {
        AbstractBlock.Properties craftingBlockProps = AE2Extras.defaultProps(Material.field_151573_f, MaterialColor.field_151670_w);
        STORAGE256K = (Block)AE2Extras.register(event.getRegistry(), "256k_crafting_storage", new CraftingStorageBlockEx(craftingBlockProps, STORAGE_256K));
        STORAGE1M = (Block)AE2Extras.register(event.getRegistry(), "1m_crafting_storage", new CraftingStorageBlockEx(craftingBlockProps, STORAGE_1M));
        STORAGE4M = (Block)AE2Extras.register(event.getRegistry(), "4m_crafting_storage", new CraftingStorageBlockEx(craftingBlockProps, STORAGE_4M));
        STORAGE16M = (Block)AE2Extras.register(event.getRegistry(), "16m_crafting_storage", new CraftingStorageBlockEx(craftingBlockProps, STORAGE_16M));
    }

    private void recipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        AE2Extras.register(event.getRegistry(), "disassemble", DisassembleRecipe.SERIALIZER);
    }

    private void items(RegistryEvent.Register<Item> event) {
        AE2Extras.register(event.getRegistry(), STORAGE256K.getRegistryName(), new CraftingStorageItem(STORAGE256K, props));
        AE2Extras.register(event.getRegistry(), STORAGE1M.getRegistryName(), new CraftingStorageItem(STORAGE1M, props));
        AE2Extras.register(event.getRegistry(), STORAGE4M.getRegistryName(), new CraftingStorageItem(STORAGE4M, props));
        AE2Extras.register(event.getRegistry(), STORAGE16M.getRegistryName(), new CraftingStorageItem(STORAGE16M, props));
        AE2Extras.register(event.getRegistry(), "256k_cell_component", CELL_COMPONENT_256K);
        AE2Extras.register(event.getRegistry(), "1m_cell_component", CELL_COMPONENT_1M);
        AE2Extras.register(event.getRegistry(), "4m_cell_component", CELL_COMPONENT_4M);
        AE2Extras.register(event.getRegistry(), "16m_cell_component", CELL_COMPONENT_16M);
        AE2Extras.register(event.getRegistry(), "256k_storage_cell", ITEM_CELL_256K);
        AE2Extras.register(event.getRegistry(), "1m_storage_cell", ITEM_CELL_1M);
        AE2Extras.register(event.getRegistry(), "4m_storage_cell", ITEM_CELL_4M);
        AE2Extras.register(event.getRegistry(), "16m_storage_cell", ITEM_CELL_16M);
        AE2Extras.register(event.getRegistry(), "256k_fluid_cell_component", FLUID_CELL_COMPONENT_256K);
        AE2Extras.register(event.getRegistry(), "1m_fluid_cell_component", FLUID_CELL_COMPONENT_1M);
        AE2Extras.register(event.getRegistry(), "4m_fluid_cell_component", FLUID_CELL_COMPONENT_4M);
        AE2Extras.register(event.getRegistry(), "16m_fluid_cell_component", FLUID_CELL_COMPONENT_16M);
        AE2Extras.register(event.getRegistry(), "256k_fluid_storage_cell", FLUID_CELL_256K);
        AE2Extras.register(event.getRegistry(), "1m_fluid_storage_cell", FLUID_CELL_1M);
        AE2Extras.register(event.getRegistry(), "4m_fluid_storage_cell", FLUID_CELL_4M);
        AE2Extras.register(event.getRegistry(), "16m_fluid_storage_cell", FLUID_CELL_16M);
    }

    private static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, ResourceLocation name, T obj) {
        registry.register((IForgeRegistryEntry)obj.setRegistryName(name));
        return obj;
    }

    private static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, String name, T obj) {
        AE2Extras.register(registry, new ResourceLocation(MODID, name), obj);
        return obj;
    }

    public static AbstractBlock.Properties defaultProps(Material material, MaterialColor color) {
        return AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color).func_200948_a(2.2f, 11.0f).harvestTool(ToolType.PICKAXE).harvestLevel(0).func_200947_a(SoundType.field_185852_e);
    }

    public static <T, E extends Throwable> T typeSwitch(AbstractCraftingUnitBlock.CraftingUnitType type, T o1, T o2, T o3, T o4, E o5) throws E {
        if (type == STORAGE_256K) {
            return o1;
        }
        if (type == STORAGE_1M) {
            return o2;
        }
        if (type == STORAGE_4M) {
            return o3;
        }
        if (type == STORAGE_16M) {
            return o4;
        }
        throw o5;
    }

    static {
        TAB = new ItemGroup(MODID){

            public ItemStack func_78016_d() {
                return STORAGE16M.func_199767_j().func_190903_i();
            }
        };
        props = new Item.Properties().func_200916_a(TAB);
        props_nostack = new Item.Properties().func_200916_a(TAB).func_200917_a(1);
        CELL_COMPONENT_256K = new Item(props);
        ITEM_CELL_256K = new AdvancedStorageCellItem(props_nostack, 256, 2.5, () -> CELL_COMPONENT_256K);
        CELL_COMPONENT_1M = new Item(props);
        ITEM_CELL_1M = new AdvancedStorageCellItem(props_nostack, 1024, 3.0, () -> CELL_COMPONENT_1M);
        CELL_COMPONENT_4M = new Item(props);
        ITEM_CELL_4M = new AdvancedStorageCellItem(props_nostack, 4096, 3.5, () -> CELL_COMPONENT_4M);
        CELL_COMPONENT_16M = new Item(props);
        ITEM_CELL_16M = new AdvancedStorageCellItem(props_nostack, 16384, 4.0, () -> CELL_COMPONENT_16M);
        FLUID_CELL_COMPONENT_256K = new Item(props);
        FLUID_CELL_256K = new AdvancedFluidStorageCellItem(props_nostack, 256, 2.5, () -> FLUID_CELL_COMPONENT_256K);
        FLUID_CELL_COMPONENT_1M = new Item(props);
        FLUID_CELL_1M = new AdvancedFluidStorageCellItem(props_nostack, 1024, 3.0, () -> FLUID_CELL_COMPONENT_1M);
        FLUID_CELL_COMPONENT_4M = new Item(props);
        FLUID_CELL_4M = new AdvancedFluidStorageCellItem(props_nostack, 4096, 3.5, () -> FLUID_CELL_COMPONENT_4M);
        FLUID_CELL_COMPONENT_16M = new Item(props);
        FLUID_CELL_16M = new AdvancedFluidStorageCellItem(props_nostack, 16384, 4.0, () -> FLUID_CELL_COMPONENT_16M);
    }
}

