/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.network.message;

import com.mrcrayfish.furniture.common.mail.Mail;
import com.mrcrayfish.furniture.common.mail.PostOffice;
import com.mrcrayfish.furniture.inventory.container.PostBoxContainer;
import com.mrcrayfish.furniture.network.message.IMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSendMail
implements IMessage<MessageSendMail> {
    private UUID playerId;
    private UUID mailBoxId;

    public MessageSendMail() {
    }

    public MessageSendMail(UUID playerId, UUID mailBoxId) {
        this.playerId = playerId;
        this.mailBoxId = mailBoxId;
    }

    @Override
    public void encode(MessageSendMail message, PacketBuffer buffer) {
        buffer.func_179252_a(message.playerId);
        buffer.func_179252_a(message.mailBoxId);
    }

    @Override
    public MessageSendMail decode(PacketBuffer buffer) {
        return new MessageSendMail(buffer.func_179253_g(), buffer.func_179253_g());
    }

    @Override
    public void handle(MessageSendMail message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            PostBoxContainer container;
            ServerPlayerEntity entity = ((NetworkEvent.Context)supplier.get()).getSender();
            if (entity != null && entity.field_71070_bA instanceof PostBoxContainer && !(container = (PostBoxContainer)entity.field_71070_bA).getMail().func_190926_b()) {
                Mail mail = new Mail("Yo", container.getMail(), entity.func_200200_C_().getString());
                if (PostOffice.sendMailToPlayer(message.playerId, message.mailBoxId, mail)) {
                    container.removeMail();
                } else {
                    entity.func_145747_a((ITextComponent)new TranslationTextComponent("message.cfm.mail_queue_full"), this.playerId);
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

