/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.tile;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.roguelogix.phosphophyllite.tile.IModularTile;
import net.roguelogix.phosphophyllite.tile.ITileModule;
import net.roguelogix.phosphophyllite.tile.ModuleRegistry;
import net.roguelogix.phosphophyllite.tile.PhosphophylliteBlock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PhosphophylliteTile
extends TileEntity
implements IModularTile {
    public static final Logger LOGGER = LogManager.getLogger((String)"Phosphophyllite/ModularTile");
    private final LinkedHashMap<Class<?>, ITileModule> modules = new LinkedHashMap();
    private final ArrayList<ITileModule> moduleList = new ArrayList();

    public PhosphophylliteTile(TileEntityType<?> tileEntityTypeIn, BlockState blockState) {
        super(tileEntityTypeIn);
        if (!(blockState.func_177230_c() instanceof PhosphophylliteBlock)) {
            throw new IllegalStateException("PhosphophylliteTiles must only be on a PhosphophylliteBlock");
        }
        Class<?> thisClazz = this.getClass();
        ModuleRegistry.forEach((clazz, constructor) -> {
            if (clazz.isAssignableFrom(thisClazz)) {
                ITileModule module = (ITileModule)constructor.apply(this);
                this.modules.put((Class<?>)clazz, module);
                this.moduleList.add(module);
            }
        });
    }

    @Override
    public ITileModule getModule(Class<?> interfaceClazz) {
        return this.modules.get(interfaceClazz);
    }

    public final void onLoad() {
        super.onLoad();
        this.moduleList.forEach(ITileModule::onAdded);
        this.onAdded();
    }

    public void onAdded() {
    }

    public final void func_145843_s() {
        super.func_145843_s();
        this.moduleList.forEach(module -> module.onRemoved(false));
        this.onRemoved(false);
    }

    public final void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.moduleList.forEach(module -> module.onRemoved(true));
        this.onRemoved(true);
    }

    public void onRemoved(boolean chunkUnload) {
    }

    public final void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound.func_74775_l("super"));
        if (compound.func_74764_b("local")) {
            CompoundNBT local = compound.func_74775_l("local");
            this.readNBT(local);
        }
        CompoundNBT subNBTs = compound.func_74775_l("sub");
        for (ITileModule module : this.moduleList) {
            String key = module.saveKey();
            if (!subNBTs.func_74764_b(key)) continue;
            CompoundNBT nbt = subNBTs.func_74775_l(key);
            module.readNBT(nbt);
        }
    }

    public final CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT superNBT = super.func_189515_b(compound);
        CompoundNBT subNBTs = new CompoundNBT();
        for (ITileModule module : this.moduleList) {
            CompoundNBT nbt = module.writeNBT();
            if (nbt == null) continue;
            String key = module.saveKey();
            if (subNBTs.func_74764_b(key)) {
                LOGGER.warn("Multiple modules with the same save key \"" + key + "\" for tile type \"" + this.getClass().getSimpleName() + "\" at " + this.func_174877_v());
            }
            subNBTs.func_218657_a(key, (INBT)nbt);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("super", (INBT)superNBT);
        nbt.func_218657_a("sub", (INBT)subNBTs);
        CompoundNBT localNBT = this.writeNBT();
        if (localNBT != null) {
            nbt.func_218657_a("local", (INBT)localNBT);
        }
        return nbt;
    }

    protected void readNBT(CompoundNBT compound) {
    }

    @Nullable
    protected CompoundNBT writeNBT() {
        return null;
    }

    public final void handleUpdateTag(BlockState state, CompoundNBT compound) {
        super.handleUpdateTag(state, compound.func_74775_l("super"));
        if (compound.func_74764_b("local")) {
            CompoundNBT local = compound.func_74775_l("local");
            this.handleDataNBT(local);
        }
        CompoundNBT subNBTs = compound.func_74775_l("sub");
        for (ITileModule module : this.moduleList) {
            String key = module.saveKey();
            if (!subNBTs.func_74764_b(key)) continue;
            CompoundNBT nbt = subNBTs.func_74775_l(key);
            module.handleDataNBT(nbt);
        }
    }

    public final CompoundNBT func_189517_E_() {
        CompoundNBT superNBT = super.func_189517_E_();
        CompoundNBT subNBTs = new CompoundNBT();
        for (ITileModule module : this.moduleList) {
            CompoundNBT nbt = module.getDataNBT();
            if (nbt == null) continue;
            String key = module.saveKey();
            if (subNBTs.func_74764_b(key)) {
                LOGGER.warn("Multiple modules with the same save key \"" + key + "\" for tile type \"" + this.getClass().getSimpleName() + "\" at " + this.func_174877_v());
            }
            subNBTs.func_218657_a(key, (INBT)nbt);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("super", (INBT)superNBT);
        nbt.func_218657_a("sub", (INBT)subNBTs);
        CompoundNBT localNBT = this.getDataNBT();
        if (localNBT != null) {
            nbt.func_218657_a("local", (INBT)localNBT);
        }
        return nbt;
    }

    protected void handleDataNBT(CompoundNBT nbt) {
        this.readNBT(nbt);
    }

    @Nullable
    protected CompoundNBT getDataNBT() {
        return this.writeNBT();
    }

    public final void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        CompoundNBT compound = pkt.func_148857_g();
        if (compound.func_74764_b("local")) {
            CompoundNBT local = compound.func_74775_l("local");
            this.handleUpdateNBT(local);
        }
        CompoundNBT subNBTs = compound.func_74775_l("sub");
        for (ITileModule module : this.moduleList) {
            String key = module.saveKey();
            if (!subNBTs.func_74764_b(key)) continue;
            CompoundNBT nbt = subNBTs.func_74775_l(key);
            module.handleUpdateNBT(nbt);
        }
    }

    @Nullable
    public final SUpdateTileEntityPacket func_189518_D_() {
        boolean sendPacket = false;
        CompoundNBT subNBTs = new CompoundNBT();
        for (ITileModule module : this.moduleList) {
            CompoundNBT nbt = module.getUpdateNBT();
            if (nbt == null) continue;
            sendPacket = true;
            String key = module.saveKey();
            if (subNBTs.func_74764_b(key)) {
                LOGGER.warn("Multiple modules with the same save key \"" + key + "\" for tile type \"" + this.getClass().getSimpleName() + "\" at " + this.func_174877_v());
            }
            subNBTs.func_218657_a(key, (INBT)nbt);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("sub", (INBT)subNBTs);
        CompoundNBT localNBT = this.getUpdateNBT();
        if (localNBT != null) {
            sendPacket = true;
            nbt.func_218657_a("local", (INBT)localNBT);
        }
        if (!sendPacket) {
            return null;
        }
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, nbt);
    }

    void handleUpdateNBT(CompoundNBT nbt) {
    }

    @Nullable
    CompoundNBT getUpdateNBT() {
        return null;
    }

    @Nonnull
    public final <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        LazyOptional<T> optional = this.capability(cap, side);
        for (ITileModule module : this.moduleList) {
            LazyOptional<T> moduleOptional = module.capability(cap, side);
            if (!moduleOptional.isPresent()) continue;
            if (optional.isPresent()) {
                LOGGER.warn("Multiple implementations of same capability \"" + cap.getName() + "\" on " + side + " side for tile type \"" + this.getClass().getSimpleName() + "\" at " + this.func_174877_v());
                continue;
            }
            optional = moduleOptional;
        }
        return optional;
    }

    <T> LazyOptional<T> capability(Capability<T> cap, @Nullable Direction side) {
        return LazyOptional.empty();
    }

    void onBlockUpdate(BlockPos neighborPos) {
        assert (this.field_145850_b != null);
        BlockState neighborBlockState = this.field_145850_b.func_180495_p(neighborPos);
        for (ITileModule module : this.moduleList) {
            module.onBlockUpdate(neighborBlockState, neighborPos);
        }
    }
}

