/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.repack.tnjson;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.roguelogix.phosphophyllite.repack.tnjson.IGetCollection;
import net.roguelogix.phosphophyllite.repack.tnjson.ParseException;

class JsonParser {
    public static final String DEFAULT_LIST_KEY = "list";
    public static final String PATH_ROOT_KEY = "root";
    private IGetCollection listener;
    private static final String NULL = "null";
    private static final String BOOL_TRUE = "true";
    private static final String BOOL_FALSE = "false";
    private static final String NUM_INFINITY = "infinity";
    private static final String NUM_INFINITY_PSITIVE = "+infinity";
    private static final String NUM_INFINITY_NEGATIVE = "-infinity";
    private static final String NUM_NAN = "nan";
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char LS = '\u2028';
    private static final char PS = '\u2029';
    private Map<String, Object> resultMap;
    private String content;
    private int maxLength;
    private int index;

    JsonParser() {
    }

    JsonParser(IGetCollection listener) {
        this.listener = listener;
    }

    Map<String, Object> doParse(String data) {
        this.content = data.trim();
        this.maxLength = this.content.length();
        this.index = 0;
        Path emptypath = new Path(PATH_ROOT_KEY);
        this.resultMap = this.getCollectionForObject(emptypath);
        this.parseEmpty(emptypath);
        return this.resultMap;
    }

    private void parseEmpty(Path emptypath) {
        while (this.index < this.maxLength) {
            char c = this.getTokenBegin();
            if (c == '{') {
                ++this.index;
                this.resultMap = this.parseMap(emptypath);
                return;
            }
            if (c == '[') {
                ++this.index;
                Collection list = this.parseList(emptypath);
                this.resultMap.put(DEFAULT_LIST_KEY, list);
            }
            ++this.index;
        }
    }

    private Map<String, Object> parseMap(Path path) {
        Map<String, Object> map = this.getCollectionForObject(path);
        while (this.index < this.maxLength) {
            char c = this.getTokenBegin();
            if (this.index >= this.maxLength) {
                throw new ParseException("Invalid JSON given, unfinished map found", this.index, "");
            }
            if (c == '}') {
                ++this.index;
                return map;
            }
            String key = this.extractIdenty(path);
            String pathForLog = path.getName() + "." + key;
            c = this.getTokenBegin();
            if (c != ':') {
                throw new ParseException("Invalid character '" + this.charToLog(c) + "' at position " + this.index + ", path '" + pathForLog + "', expected ':'.", this.index, pathForLog);
            }
            ++this.index;
            Object val = this.extractValue(path.add(key));
            map.put(key, val);
            c = this.getTokenBegin();
            if (c == '}') {
                ++this.index;
                return map;
            }
            if (c == ',') {
                ++this.index;
                continue;
            }
            throw new ParseException("Invalid character '" + this.charToLog(c) + "' at position " + this.index + ", last path '" + pathForLog + "', expected ',' or '}'.", this.index, pathForLog);
        }
        return map;
    }

    private Collection parseList(Path path) {
        Collection list = this.getCollectionForList(path);
        while (this.index < this.maxLength) {
            char c = this.getTokenBegin();
            if (c == ']') {
                ++this.index;
                return list;
            }
            if (c == ',') {
                ++this.index;
                continue;
            }
            Object val = this.extractValue(path);
            list.add(val);
        }
        return list;
    }

    private char getTokenBegin() {
        while (this.index < this.maxLength) {
            char c = this.content.charAt(this.index);
            if (Character.isLetterOrDigit(c) || c == '\"' || c == '\'' || c == '@' || c == '#' || c == '$' || c == '_' || c == '{' || c == '}' || c == ':' || c == '[' || c == ']' || c == ',' || c == '+' || c == '-' || c == '.') {
                return c;
            }
            if (c == '\\') {
                return c;
            }
            if (c == '/') {
                char next = this.content.charAt(this.index + 1);
                if (next == '/') {
                    this.skipToEndLine();
                } else if (next == '*') {
                    this.index += 2;
                    this.skipToEndComent();
                }
            }
            ++this.index;
        }
        return '\u0000';
    }

    private void skipToEndLine() {
        while (this.index < this.maxLength) {
            char c = this.content.charAt(this.index);
            if (this.isLineTerminator(c)) {
                return;
            }
            ++this.index;
        }
    }

    private void skipToEndComent() {
        while (this.index < this.maxLength) {
            char c = this.content.charAt(this.index);
            if (c == '*') {
                ++this.index;
                c = this.content.charAt(this.index);
                if (c == '/') {
                    return;
                }
            }
            ++this.index;
        }
    }

    private String extractIdenty(Path path) {
        char c = this.content.charAt(this.index);
        char terminator = c == '\"' || c == '\'' ? c : (char)'\u0000';
        StringBuilder b = new StringBuilder();
        while (this.index < this.maxLength) {
            c = this.content.charAt(this.index);
            if (c == terminator) {
                ++this.index;
                if (b.length() == 0) continue;
                return b.toString().trim();
            }
            if (terminator == '\u0000' && (c == ':' || c == '/' || this.isWhiteSpace(c))) {
                return b.toString().trim();
            }
            if (c == '\\') {
                c = this.getCharFromEscapedText();
            }
            if (terminator == '\u0000' && (c == '\'' || c == '\"') || this.isLineTerminator(c)) {
                throw new ParseException("Invalid character '" + this.charToLog(c) + "' for identifier '" + b.toString() + "' at position " + this.index + ", path '" + path.getName() + "'.", this.index, path.getName());
            }
            b.append(c);
            ++this.index;
        }
        return b.toString().trim();
    }

    private Object extractValue(Path path) {
        char c = this.getTokenBegin();
        if (c == '{') {
            ++this.index;
            Map<String, Object> map = this.parseMap(path);
            return map;
        }
        if (c == '[') {
            ++this.index;
            Collection list = this.parseList(path);
            return list;
        }
        if (c == '\"' || c == '\'') {
            String str = this.extractString();
            return str;
        }
        Object num = this.extractLiteral(path);
        return num;
    }

    private Object extractLiteral(Path path) {
        String literal;
        StringBuilder b = new StringBuilder();
        while (this.index < this.maxLength) {
            char c = this.content.charAt(this.index);
            if (c == '+' && b.length() == 0) {
                ++this.index;
                continue;
            }
            if (!Character.isLetterOrDigit(c) && c != '.' && c != '+' && c != '-') break;
            b.append(c);
            ++this.index;
        }
        switch (literal = b.toString().trim().toLowerCase()) {
            case "null": {
                return null;
            }
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
            case "infinity": {
                return Double.POSITIVE_INFINITY;
            }
            case "+infinity": {
                return Double.POSITIVE_INFINITY;
            }
            case "-infinity": {
                return Double.NEGATIVE_INFINITY;
            }
            case "nan": {
                return Double.NaN;
            }
        }
        try {
            return this.detectNumber(literal);
        }
        catch (Exception ex) {
            throw new ParseException("Invalid literal '" + literal + "' at position " + this.index + ", path '" + path.getName() + "'.", this.index, path.getName());
        }
    }

    private Object detectNumber(String literal) {
        int maxlonglen;
        boolean hasX;
        boolean hasDot = literal.indexOf(46) >= 0;
        boolean hasE = literal.indexOf(101) >= 0;
        boolean bl = hasX = literal.indexOf(120) >= 0;
        if (hasDot || hasE && !hasX) {
            return Double.parseDouble(literal);
        }
        int maxintlen = hasX ? 9 : 9;
        int n = maxlonglen = hasX ? 17 : 18;
        if (literal.charAt(0) == '-') {
            ++maxintlen;
            ++maxlonglen;
        }
        if (literal.length() <= maxintlen) {
            return Integer.decode(literal);
        }
        if (literal.length() <= maxlonglen) {
            return Long.decode(literal);
        }
        return new BigInteger(literal);
    }

    private String extractString() {
        char terminator = this.content.charAt(this.index);
        ++this.index;
        StringBuilder b = new StringBuilder();
        while (this.index < this.maxLength) {
            char c = this.content.charAt(this.index);
            if (c == '\\') {
                char ce = this.getCharFromEscapedText();
                b.append(ce);
                ++this.index;
                continue;
            }
            if (c == terminator) {
                ++this.index;
                break;
            }
            b.append(c);
            ++this.index;
        }
        return b.toString().trim();
    }

    private char getCharFromEscapedText() {
        char resultChar;
        ++this.index;
        char next = this.content.charAt(this.index);
        switch (next) {
            case 'b': {
                resultChar = '\b';
                break;
            }
            case 'f': {
                resultChar = '\f';
                break;
            }
            case 'n': {
                resultChar = '\n';
                break;
            }
            case 'r': {
                resultChar = '\r';
                break;
            }
            case 't': {
                resultChar = '\t';
                break;
            }
            case 'v': {
                resultChar = '\u000b';
                break;
            }
            case '0': {
                resultChar = '\u0000';
                break;
            }
            case '\'': {
                resultChar = '\'';
                break;
            }
            case '\"': {
                resultChar = '\"';
                break;
            }
            case '\\': {
                resultChar = '\\';
                break;
            }
            case 'u': {
                StringBuilder bu = new StringBuilder();
                bu.append(this.content.charAt(++this.index));
                bu.append(this.content.charAt(++this.index));
                bu.append(this.content.charAt(++this.index));
                bu.append(this.content.charAt(++this.index));
                int hexValU = Integer.parseInt(bu.toString(), 16);
                resultChar = (char)hexValU;
                break;
            }
            case 'X': 
            case 'x': {
                StringBuilder bx = new StringBuilder();
                char cx = this.content.charAt(this.index + 1);
                while (this.isHexadecimalChar(cx)) {
                    bx.append(cx);
                    ++this.index;
                    cx = this.content.charAt(this.index + 1);
                }
                int hexValX = Integer.parseInt(bx.toString(), 16);
                resultChar = (char)hexValX;
                break;
            }
            default: {
                return next;
            }
        }
        return resultChar;
    }

    private boolean isLineTerminator(char c) {
        return c == '\n' || c == '\r' || c == '\u2028' || c == '\u2029';
    }

    private boolean isWhiteSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\u0085': 
            case '\u00a0': 
            case '\u1680': 
            case '\u2000': 
            case '\u2001': 
            case '\u2002': 
            case '\u2003': 
            case '\u2004': 
            case '\u2005': 
            case '\u2006': 
            case '\u2007': 
            case '\u2008': 
            case '\u2009': 
            case '\u200a': 
            case '\u2028': 
            case '\u2029': 
            case '\u202f': 
            case '\u205f': 
            case '\u3000': {
                return true;
            }
        }
        return false;
    }

    private boolean isHexadecimalChar(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c >= 'A' && c <= 'F') {
            return true;
        }
        return c >= 'a' && c <= 'f';
    }

    private String charToLog(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\'': {
                return "'";
            }
            case '\"': {
                return "\"";
            }
            case '\u2028': {
                return "LS (0x2028)";
            }
            case '\u2029': {
                return "PS (0x2029)";
            }
            case '\u0000': {
                return "null (0x0000)";
            }
        }
        return String.valueOf(c);
    }

    private Map<String, Object> getCollectionForObject(Path path) {
        Map<String, Object> result = null;
        if (this.listener != null) {
            result = this.listener.forObject(path.getName());
        }
        if (result == null) {
            result = new LinkedHashMap<String, Object>();
        }
        return result;
    }

    private Collection getCollectionForList(Path path) {
        ArrayList result = null;
        if (this.listener != null) {
            result = this.listener.forList(path.getName());
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    private class Path {
        private String path;

        public Path(String str) {
            this.path = str;
        }

        public String getName() {
            return this.path;
        }

        public Path add(String node) {
            return new Path(this.path + '.' + node);
        }
    }
}

