/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock.generic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.roguelogix.phosphophyllite.multiblock.generic.ConnectedTextureStates;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockTile;

public class MultiblockBlock<ControllerType extends MultiblockController<ControllerType, TileType, BlockType>, TileType extends MultiblockTile<ControllerType, TileType, BlockType>, BlockType extends MultiblockBlock<ControllerType, TileType, BlockType>>
extends Block {
    public static final BooleanProperty ASSEMBLED = BooleanProperty.func_177716_a((String)"assembled");

    public MultiblockBlock(AbstractBlock.Properties properties) {
        super(properties);
        BlockState defaultState = this.func_176223_P();
        if (this.usesAssemblyState()) {
            defaultState = (BlockState)defaultState.func_206870_a((Property)ASSEMBLED, (Comparable)Boolean.valueOf(false));
        }
        if (this.connectedTexture()) {
            defaultState = (BlockState)defaultState.func_206870_a((Property)ConnectedTextureStates.TOP_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(false));
            defaultState = (BlockState)defaultState.func_206870_a((Property)ConnectedTextureStates.BOTTOM_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(false));
            defaultState = (BlockState)defaultState.func_206870_a((Property)ConnectedTextureStates.NORTH_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(false));
            defaultState = (BlockState)defaultState.func_206870_a((Property)ConnectedTextureStates.SOUTH_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(false));
            defaultState = (BlockState)defaultState.func_206870_a((Property)ConnectedTextureStates.EAST_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(false));
            defaultState = (BlockState)defaultState.func_206870_a((Property)ConnectedTextureStates.WEST_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(false));
        }
        this.func_180632_j(defaultState);
    }

    public final boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean connectedTexture() {
        return false;
    }

    public boolean usesAssemblyState() {
        return true;
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World worldIn, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand handIn, @Nonnull BlockRayTraceResult hit) {
        ActionResultType tileResult;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof MultiblockTile && (tileResult = ((MultiblockTile)te).onBlockActivated(player, handIn)) != ActionResultType.PASS) {
            return tileResult;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        if (this.usesAssemblyState()) {
            builder.func_206894_a(new Property[]{ASSEMBLED});
        }
        if (this.connectedTexture()) {
            builder.func_206894_a(new Property[]{ConnectedTextureStates.TOP_CONNECTED_PROPERTY});
            builder.func_206894_a(new Property[]{ConnectedTextureStates.BOTTOM_CONNECTED_PROPERTY});
            builder.func_206894_a(new Property[]{ConnectedTextureStates.NORTH_CONNECTED_PROPERTY});
            builder.func_206894_a(new Property[]{ConnectedTextureStates.SOUTH_CONNECTED_PROPERTY});
            builder.func_206894_a(new Property[]{ConnectedTextureStates.EAST_CONNECTED_PROPERTY});
            builder.func_206894_a(new Property[]{ConnectedTextureStates.WEST_CONNECTED_PROPERTY});
        }
    }

    public void func_220069_a(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (this.connectedTexture()) {
            this.updateConnectedTextureState(worldIn, pos, state);
        }
    }

    public void func_180633_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (this.connectedTexture()) {
            this.updateConnectedTextureState(worldIn, pos, this.func_176223_P());
        }
    }

    private void updateConnectedTextureState(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        state = (BlockState)state.func_206870_a((Property)ConnectedTextureStates.TOP_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(this.connectToBlock(worldIn.func_180495_p(pos.func_177972_a(Direction.UP)).func_177230_c())));
        state = (BlockState)state.func_206870_a((Property)ConnectedTextureStates.BOTTOM_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(this.connectToBlock(worldIn.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_177230_c())));
        state = (BlockState)state.func_206870_a((Property)ConnectedTextureStates.NORTH_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(this.connectToBlock(worldIn.func_180495_p(pos.func_177972_a(Direction.NORTH)).func_177230_c())));
        state = (BlockState)state.func_206870_a((Property)ConnectedTextureStates.SOUTH_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(this.connectToBlock(worldIn.func_180495_p(pos.func_177972_a(Direction.SOUTH)).func_177230_c())));
        state = (BlockState)state.func_206870_a((Property)ConnectedTextureStates.EAST_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(this.connectToBlock(worldIn.func_180495_p(pos.func_177972_a(Direction.EAST)).func_177230_c())));
        state = (BlockState)state.func_206870_a((Property)ConnectedTextureStates.WEST_CONNECTED_PROPERTY, (Comparable)Boolean.valueOf(this.connectToBlock(worldIn.func_180495_p(pos.func_177972_a(Direction.WEST)).func_177230_c())));
        worldIn.func_180501_a(pos, state, 2);
    }

    protected boolean connectToBlock(Block block) {
        return block == this;
    }
}

