/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.roguelogix.phosphophyllite.PhosphophylliteConfig;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.robn.ROBN;

public class GuiSync {
    private static final HashMap<PlayerEntity, IGUIPacketProvider> playerGUIs = new HashMap();
    private static IGUIPacketProvider currentGUI;
    private static final String PROTOCOL_VERSION = "0";
    public static final SimpleChannel INSTANCE;

    public static synchronized void onContainerOpen(@Nonnull PlayerContainerEvent.Open e) {
        Container container = e.getContainer();
        if (container instanceof IGUIPacketProvider) {
            playerGUIs.put(e.getPlayer(), (IGUIPacketProvider)container);
        }
    }

    public static synchronized void onContainerClose(@Nonnull PlayerContainerEvent.Close e) {
        playerGUIs.remove(e.getPlayer());
    }

    public static synchronized void GuiOpenEvent(@Nonnull GuiOpenEvent e) {
        Screen gui = e.getGui();
        if (gui instanceof ContainerScreen) {
            Container container = ((ContainerScreen)gui).func_212873_a_();
            if (container instanceof IGUIPacketProvider) {
                currentGUI = (IGUIPacketProvider)container;
            }
        } else {
            currentGUI = null;
        }
    }

    @OnModLoad
    public static void onModLoad() {
        INSTANCE.registerMessage(1, GUIPacketMessage.class, GuiSync::encodePacket, GuiSync::decodePacket, GuiSync::handler);
        MinecraftForge.EVENT_BUS.addListener(GuiSync::onContainerClose);
        MinecraftForge.EVENT_BUS.addListener(GuiSync::onContainerOpen);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(GuiSync::GuiOpenEvent);
        }
        Thread updateThread = new Thread(() -> {
            while (true) {
                Class<GuiSync> clazz = GuiSync.class;
                // MONITORENTER : net.roguelogix.phosphophyllite.gui.GuiSync.class
                playerGUIs.forEach((player, gui) -> {
                    try {
                        ArrayList<Byte> buf;
                        assert (player instanceof ServerPlayerEntity);
                        IGUIPacket packet = gui.getGuiPacket();
                        if (packet == null) {
                            return;
                        }
                        Map<?, ?> packetMap = packet.write();
                        if (packetMap == null) {
                            return;
                        }
                        try {
                            buf = ROBN.toROBN(packetMap);
                        }
                        catch (IllegalStateException e) {
                            e.printStackTrace();
                            return;
                        }
                        GUIPacketMessage message = new GUIPacketMessage();
                        message.bytes = new byte[buf.size()];
                        for (int i = 0; i < buf.size(); ++i) {
                            message.bytes[i] = buf.get(i);
                        }
                        INSTANCE.sendTo((Object)message, ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                // MONITOREXIT : clazz
                try {
                    Thread.sleep(PhosphophylliteConfig.GUI.UpdateIntervalMS);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
        updateThread.setName("Phosphophyllite-GuiSync");
        updateThread.setDaemon(true);
        updateThread.start();
    }

    private static void encodePacket(@Nonnull GUIPacketMessage packet, @Nonnull PacketBuffer buf) {
        buf.writeBytes(packet.bytes);
    }

    private static GUIPacketMessage decodePacket(@Nonnull PacketBuffer buf) {
        byte[] byteBuf = new byte[buf.readableBytes()];
        buf.readBytes(byteBuf);
        return new GUIPacketMessage(byteBuf);
    }

    private static void handler(@Nonnull GUIPacketMessage packet, @Nonnull Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            NetworkDirection direction = ((NetworkEvent.Context)ctx.get()).getDirection();
            ArrayList<Byte> buf = new ArrayList<Byte>();
            for (byte aByte : packet.bytes) {
                buf.add(aByte);
            }
            Map map = (Map)ROBN.fromROBN(buf);
            if (direction == NetworkDirection.PLAY_TO_CLIENT) {
                IGUIPacket guiPacket;
                IGUIPacketProvider currentGUI = currentGUI;
                if (currentGUI != null && (guiPacket = currentGUI.getGuiPacket()) != null) {
                    guiPacket.read(map);
                }
            } else {
                IGUIPacketProvider currentGUI = playerGUIs.get(((NetworkEvent.Context)ctx.get()).getSender());
                if (currentGUI != null) {
                    currentGUI.executeRequest((String)map.get("request"), map.get("data"));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    static {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("phosphophyllite", "multiblock/guisync"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    }

    private static class GUIPacketMessage {
        public byte[] bytes;

        public GUIPacketMessage() {
        }

        public GUIPacketMessage(@Nonnull byte[] readByteArray) {
            this.bytes = readByteArray;
        }
    }

    public static interface IGUIPacket {
        public void read(@Nonnull Map<?, ?> var1);

        @Nullable
        public Map<?, ?> write();
    }

    public static interface IGUIPacketProvider {
        @Nullable
        public IGUIPacket getGuiPacket();

        default public void runRequest(@Nonnull String requestName, @Nullable Object requestData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("request", requestName);
            if (requestData != null) {
                map.put("data", requestData);
            }
            ArrayList<Byte> buf = ROBN.toROBN(map);
            GUIPacketMessage message = new GUIPacketMessage();
            message.bytes = new byte[buf.size()];
            for (int i = 0; i < buf.size(); ++i) {
                message.bytes[i] = buf.get(i);
            }
            INSTANCE.sendToServer((Object)message);
        }

        default public void executeRequest(String requestName, Object requestData) {
        }
    }
}

