/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.fluids;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.providers.IGasProvider;
import mekanism.api.recipes.RotaryRecipe;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.roguelogix.phosphophyllite.fluids.IPhosphophylliteFluidHandler;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.threading.Event;
import net.roguelogix.phosphophyllite.threading.WorkQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MekanismGasWrappers {
    public static IGasHandler EMPTY_TANK = new IGasHandler(){

        public int getTanks() {
            return 0;
        }

        public GasStack getChemicalInTank(int tank) {
            return GasStack.EMPTY;
        }

        public void setChemicalInTank(int tank, GasStack stack) {
        }

        public long getTankCapacity(int tank) {
            return 0L;
        }

        public boolean isValid(int tank, GasStack stack) {
            return false;
        }

        public GasStack insertChemical(int tank, GasStack stack, Action action) {
            return stack;
        }

        public GasStack extractChemical(int tank, long amount, Action action) {
            return GasStack.EMPTY;
        }
    };
    private static final Logger LOGGER = LogManager.getLogger((String)"Phosphophyllite/MekanismIntegration");
    private static final Map<Gas, Mapping> gasToFluidMap = new HashMap<Gas, Mapping>();
    private static final Map<Fluid, Mapping> fluidToGasMap = new HashMap<Fluid, Mapping>();
    private static MinecraftServer server;
    private static final WorkQueue reloadQueue;

    public static IGasHandler wrap(IPhosphophylliteFluidHandler fluidHandler) {
        return new FluidToGasWrapper(fluidHandler);
    }

    public static IPhosphophylliteFluidHandler wrap(IGasHandler gasHandler) {
        return new GasToFluidWrapper(gasHandler);
    }

    @OnModLoad
    private static void onModLoad() {
        MinecraftForge.EVENT_BUS.addListener(MekanismGasWrappers::addReloadEventListener);
        MinecraftForge.EVENT_BUS.addListener(MekanismGasWrappers::serverAboutToStart);
    }

    private static void addReloadEventListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new ReloadListener<Void>(){

            protected Void prepare(IResourceManager resourceManagerIn, IProfiler profilerIn) {
                return null;
            }

            protected void apply(Void objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
                reloadQueue.enqueue(() -> MekanismGasWrappers.reloadMappings(), new Event[0]);
                if (server != null) {
                    reloadQueue.runAll();
                }
            }
        });
    }

    private static void serverAboutToStart(FMLServerAboutToStartEvent event) {
        server = event.getServer();
        reloadQueue.runAll();
    }

    private static long GCD(long A, long B) {
        long A2 = A >> 1;
        long B2 = B >> 1;
        long GCD = 1L;
        for (long i = 2L; i < A2 && i < B2; ++i) {
            long Ai = A / i * i;
            long Bi = B / i * i;
            if (Ai != A || Bi != B) continue;
            GCD = i;
        }
        return GCD;
    }

    private static void reloadMappings() {
        gasToFluidMap.forEach((k, v) -> {
            v.fluids.clear();
            v.gases.clear();
        });
        fluidToGasMap.forEach((k, v) -> {
            v.fluids.clear();
            v.gases.clear();
        });
        gasToFluidMap.clear();
        fluidToGasMap.clear();
        IRecipeType type = (IRecipeType)Registry.field_218367_H.func_82594_a(new ResourceLocation("mekanism:rotary"));
        if (type == null || server == null) {
            return;
        }
        List recipes = server.func_199529_aN().func_241447_a_(type);
        for (RotaryRecipe recipe : recipes) {
            FluidStack output;
            long amount;
            List inputs;
            Mapping mapping = new Mapping();
            if (recipe.hasGasToFluid()) {
                inputs = recipe.getGasInput().getRepresentations();
                for (GasStack input : inputs) {
                    Gas gas = (Gas)input.getType();
                    amount = input.getAmount();
                    if (mapping.gasToFluidGasUnits != -1L && mapping.gasToFluidGasUnits != amount) {
                        LOGGER.warn("Input amount discrepancy in rotary recipe " + recipe.func_199560_c() + " with gas " + gas.getName() + " wanting " + amount + " input while a different gas wants " + mapping.gasToFluidGasUnits);
                        continue;
                    }
                    if (!mapping.gases.contains(gas)) {
                        mapping.gases.add(gas);
                    }
                    mapping.gasToFluidGasUnits = amount;
                }
                output = recipe.getFluidOutputRepresentation();
                if (!mapping.fluids.contains(output.getRawFluid())) {
                    mapping.fluids.add(output.getRawFluid());
                }
                mapping.gasToFluidFluidUnits = output.getAmount();
                if (mapping.gasToFluidGasUnits <= 0L || mapping.gasToFluidFluidUnits <= 0L) {
                    mapping.gasToFluidGasUnits = -1L;
                    mapping.gasToFluidFluidUnits = -1L;
                }
                long GCD = MekanismGasWrappers.GCD(mapping.gasToFluidGasUnits, mapping.gasToFluidFluidUnits);
                mapping.gasToFluidGasUnits /= GCD;
                mapping.gasToFluidFluidUnits /= GCD;
            }
            if (recipe.hasFluidToGas()) {
                inputs = recipe.getFluidInput().getRepresentations();
                for (FluidStack input : inputs) {
                    Fluid fluid = input.getRawFluid();
                    amount = input.getAmount();
                    if (mapping.gasToFluidGasUnits != -1L && mapping.gasToFluidGasUnits != amount) {
                        LOGGER.warn("Input amount discrepancy in rotary recipe " + recipe.func_199560_c() + " with fluid " + fluid.getRegistryName() + " wanting " + amount + " input while a different gas wants " + mapping.fluidToGasFluidUnits);
                        continue;
                    }
                    if (!mapping.fluids.contains(fluid)) {
                        mapping.fluids.add(fluid);
                    }
                    mapping.fluidToGasFluidUnits = amount;
                }
                output = recipe.getGasOutputRepresentation();
                if (!mapping.gases.contains(output.getRaw())) {
                    mapping.gases.add((Gas)output.getRaw());
                }
                mapping.fluidToGasGasUnits = output.getAmount();
                if (mapping.fluidToGasGasUnits <= 0L || mapping.fluidToGasFluidUnits <= 0L) {
                    mapping.fluidToGasGasUnits = -1L;
                    mapping.fluidToGasFluidUnits = -1L;
                }
                long GCD = MekanismGasWrappers.GCD(mapping.fluidToGasGasUnits, mapping.fluidToGasFluidUnits);
                mapping.fluidToGasGasUnits /= GCD;
                mapping.fluidToGasFluidUnits /= GCD;
            }
            for (Gas gas : mapping.gases) {
                Mapping oldMapping = gasToFluidMap.put(gas, mapping);
                if (oldMapping != null) {
                    LOGGER.warn("Duplicate gas entry for gas " + gas.getName());
                }
                mapping.gasStacks.add(gas.getStack(0L));
            }
            for (Fluid fluid : mapping.fluids) {
                Mapping oldMapping = fluidToGasMap.put(fluid, mapping);
                if (oldMapping != null) {
                    LOGGER.warn("Duplicate fluid entry for fluid " + fluid.getRegistryName());
                }
                mapping.fluidStacks.add(new FluidStack(fluid, 0));
            }
        }
    }

    private static void removeMapping(Mapping mapping) {
        for (Gas gas : mapping.gases) {
            gasToFluidMap.remove(gas);
        }
        for (Fluid fluid : mapping.fluids) {
            fluidToGasMap.remove(fluid);
        }
        mapping.gases.clear();
        mapping.fluids.clear();
    }

    static {
        reloadQueue = new WorkQueue();
    }

    private static class FluidToGasWrapper
    implements IGasHandler {
        IPhosphophylliteFluidHandler fluidHandler;
        Mapping lastMapping;

        private FluidToGasWrapper(IPhosphophylliteFluidHandler handler) {
            this.fluidHandler = handler;
        }

        public int getTanks() {
            return this.fluidHandler.tankCount();
        }

        public GasStack getChemicalInTank(int tank) {
            Fluid fluid = this.fluidHandler.fluidTypeInTank(tank);
            long amount = this.fluidHandler.fluidAmountInTank(tank);
            if (this.lastMapping == null || !this.lastMapping.fluids.contains(fluid)) {
                Mapping map = (Mapping)fluidToGasMap.get(fluid);
                if (map == null) {
                    return GasStack.EMPTY;
                }
                this.lastMapping = map;
            }
            if (this.lastMapping.gases.isEmpty()) {
                LOGGER.error("Fluid mapping for " + fluid.getRegistryName() + " has zero gas elements, removing");
                MekanismGasWrappers.removeMapping(this.lastMapping);
                this.lastMapping = null;
                return GasStack.EMPTY;
            }
            amount *= this.lastMapping.fluidToGasGasUnits;
            GasStack stack = this.lastMapping.gasStacks.get(0);
            stack.setAmount(amount /= this.lastMapping.fluidToGasFluidUnits);
            return stack;
        }

        public void setChemicalInTank(int tank, GasStack stack) {
            throw new RuntimeException("Not implemented for this handler");
        }

        public long getTankCapacity(int tank) {
            return this.fluidHandler.getTankCapacity(tank);
        }

        public boolean isValid(int tank, GasStack stack) {
            if (this.lastMapping == null || !this.lastMapping.gases.contains(stack.getRaw())) {
                Mapping map = (Mapping)gasToFluidMap.get(stack.getRaw());
                if (map == null) {
                    return false;
                }
                this.lastMapping = map;
            }
            if (this.lastMapping.fluids.isEmpty()) {
                LOGGER.error("Gas mapping for " + ((Gas)stack.getRaw()).getRegistryName() + " has zero fluid elements, removing");
                MekanismGasWrappers.removeMapping(this.lastMapping);
                this.lastMapping = null;
                return false;
            }
            return this.fluidHandler.fluidValidForTank(tank, this.lastMapping.fluids.get(0));
        }

        public GasStack insertChemical(int tank, GasStack stack, Action action) {
            if (this.lastMapping == null || !this.lastMapping.gases.contains(stack.getRaw())) {
                Mapping map = (Mapping)gasToFluidMap.get(stack.getRaw());
                if (map == null) {
                    return stack;
                }
                this.lastMapping = map;
            }
            if (this.lastMapping.fluids.isEmpty()) {
                LOGGER.error("Gas mapping for " + ((Gas)stack.getRaw()).getRegistryName() + " has zero fluid elements, removing");
                MekanismGasWrappers.removeMapping(this.lastMapping);
                this.lastMapping = null;
                return stack;
            }
            if (this.lastMapping.gasToFluidFluidUnits <= 0L) {
                return stack;
            }
            Fluid fluid = this.lastMapping.fluids.get(0);
            long amount = stack.getAmount();
            amount *= this.lastMapping.gasToFluidFluidUnits;
            long filled = this.fluidHandler.fill(fluid, null, amount /= this.lastMapping.gasToFluidGasUnits, action.simulate());
            if (filled == 0L) {
                return stack;
            }
            if (filled == amount) {
                return GasStack.EMPTY;
            }
            long remaining = amount - filled;
            remaining *= this.lastMapping.gasToFluidGasUnits;
            return new GasStack(stack, remaining /= this.lastMapping.gasToFluidFluidUnits);
        }

        public GasStack extractChemical(int tank, long gasAmount, Action action) {
            Fluid fluid = this.fluidHandler.fluidTypeInTank(tank);
            if (this.lastMapping == null || !this.lastMapping.fluids.contains(fluid)) {
                Mapping map = (Mapping)fluidToGasMap.get(fluid);
                if (map == null) {
                    return GasStack.EMPTY;
                }
                this.lastMapping = map;
            }
            if (this.lastMapping.gases.isEmpty()) {
                LOGGER.error("Fluid mapping for " + fluid + " has zero gas elements, removing");
                MekanismGasWrappers.removeMapping(this.lastMapping);
                this.lastMapping = null;
                return GasStack.EMPTY;
            }
            if (this.lastMapping.fluidToGasFluidUnits <= 0L) {
                return GasStack.EMPTY;
            }
            long amount = gasAmount;
            amount *= this.lastMapping.fluidToGasFluidUnits;
            long drained = this.fluidHandler.drain(fluid, null, amount /= this.lastMapping.fluidToGasGasUnits, action.simulate());
            if (drained == 0L) {
                return GasStack.EMPTY;
            }
            long gasDrained = amount - drained;
            gasDrained *= this.lastMapping.fluidToGasGasUnits;
            return new GasStack((IGasProvider)this.lastMapping.gases.get(0), gasDrained /= this.lastMapping.fluidToGasFluidUnits);
        }
    }

    private static class GasToFluidWrapper
    implements IPhosphophylliteFluidHandler {
        IGasHandler gasHandler;
        Mapping lastMapping;

        GasToFluidWrapper(IGasHandler handler) {
            this.gasHandler = handler;
        }

        @Override
        public int tankCount() {
            return this.gasHandler.getTanks();
        }

        @Override
        public long tankCapacity(int tank) {
            return this.gasHandler.getTankCapacity(tank);
        }

        @Override
        public Fluid fluidTypeInTank(int tank) {
            GasStack gasStack = (GasStack)this.gasHandler.getChemicalInTank(tank);
            if (this.lastMapping == null || !this.lastMapping.gases.contains(gasStack.getRaw())) {
                Mapping map = (Mapping)gasToFluidMap.get(gasStack.getRaw());
                if (map == null) {
                    return Fluids.field_204541_a;
                }
                this.lastMapping = map;
            }
            if (this.lastMapping.fluids.isEmpty()) {
                LOGGER.error("Gas mapping for " + ((Gas)gasStack.getRaw()).getName() + " has zero fluid elements, removing");
                MekanismGasWrappers.removeMapping(this.lastMapping);
                this.lastMapping = null;
                return Fluids.field_204541_a;
            }
            return this.lastMapping.fluids.get(0);
        }

        @Override
        public CompoundNBT fluidTagInTank(int tank) {
            return null;
        }

        @Override
        public long fluidAmountInTank(int tank) {
            if (tank > this.tankCount()) {
                return 0L;
            }
            GasStack gasStack = (GasStack)this.gasHandler.getChemicalInTank(tank);
            if (this.lastMapping == null || !this.lastMapping.gases.contains(gasStack.getRaw())) {
                Mapping map = (Mapping)gasToFluidMap.get(gasStack.getRaw());
                if (map == null) {
                    return 0L;
                }
                this.lastMapping = map;
            }
            long amount = gasStack.getAmount();
            amount *= this.lastMapping.gasToFluidFluidUnits;
            return amount /= this.lastMapping.gasToFluidGasUnits;
        }

        @Override
        public boolean fluidValidForTank(int tank, Fluid fluid) {
            if (this.lastMapping == null || !this.lastMapping.fluids.contains(fluid)) {
                Mapping map = (Mapping)fluidToGasMap.get(fluid);
                if (map == null) {
                    return false;
                }
                this.lastMapping = map;
            }
            if (this.lastMapping.gases.isEmpty()) {
                LOGGER.error("Fluid mapping for " + fluid.getRegistryName() + " has zero gas elements, removing");
                MekanismGasWrappers.removeMapping(this.lastMapping);
                this.lastMapping = null;
                return false;
            }
            return this.gasHandler.isValid(tank, (ChemicalStack)this.lastMapping.gasStacks.get(0));
        }

        @Override
        public long fill(Fluid fluid, @Nullable CompoundNBT tag, long amount, boolean simulate) {
            if (tag != null || fluid == Fluids.field_204541_a) {
                return 0L;
            }
            if (this.lastMapping == null || !this.lastMapping.fluids.contains(fluid)) {
                Mapping map = (Mapping)fluidToGasMap.get(fluid);
                if (map == null) {
                    return 0L;
                }
                this.lastMapping = map;
            }
            if (this.lastMapping.gases.isEmpty()) {
                LOGGER.error("Fluid mapping for " + fluid.getRegistryName() + " has zero gas elements, removing");
                MekanismGasWrappers.removeMapping(this.lastMapping);
                this.lastMapping = null;
                return 0L;
            }
            if (this.lastMapping.fluidToGasGasUnits <= 0L) {
                return 0L;
            }
            GasStack stack = this.lastMapping.gasStacks.get(0);
            long gasAmount = amount;
            gasAmount *= this.lastMapping.fluidToGasGasUnits;
            stack.setAmount(gasAmount /= this.lastMapping.fluidToGasFluidUnits);
            stack = (GasStack)this.gasHandler.insertChemical((ChemicalStack)stack, Action.get((!simulate ? 1 : 0) != 0));
            long remainingFluid = stack.getAmount();
            remainingFluid *= this.lastMapping.fluidToGasFluidUnits;
            return amount - (remainingFluid /= this.lastMapping.fluidToGasGasUnits);
        }

        @Override
        public long drain(Fluid fluid, @Nullable CompoundNBT tag, long amount, boolean simulate) {
            if (tag != null || fluid == Fluids.field_204541_a) {
                return 0L;
            }
            if (this.lastMapping == null || !this.lastMapping.fluids.contains(fluid)) {
                Mapping map = (Mapping)fluidToGasMap.get(fluid);
                if (map == null) {
                    return 0L;
                }
                this.lastMapping = map;
            }
            if (this.lastMapping.gases.isEmpty()) {
                LOGGER.error("Fluid mapping for " + fluid.getRegistryName() + " has zero gas elements, removing");
                MekanismGasWrappers.removeMapping(this.lastMapping);
                this.lastMapping = null;
                return 0L;
            }
            if (this.lastMapping.gasToFluidFluidUnits <= 0L) {
                return 0L;
            }
            GasStack stack = this.lastMapping.gasStacks.get(0);
            long gasAmount = amount;
            gasAmount *= this.lastMapping.gasToFluidFluidUnits;
            stack.setAmount(gasAmount /= this.lastMapping.gasToFluidGasUnits);
            stack = (GasStack)this.gasHandler.extractChemical((ChemicalStack)stack, Action.get((!simulate ? 1 : 0) != 0));
            long drained = stack.getAmount();
            drained *= this.lastMapping.gasToFluidGasUnits;
            return drained /= this.lastMapping.gasToFluidFluidUnits;
        }
    }

    private static class Mapping {
        final List<Gas> gases = new ArrayList<Gas>();
        final List<GasStack> gasStacks = new ArrayList<GasStack>();
        long gasToFluidGasUnits = -1L;
        long gasToFluidFluidUnits = -1L;
        final List<Fluid> fluids = new ArrayList<Fluid>();
        final List<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        long fluidToGasGasUnits = -1L;
        long fluidToGasFluidUnits = -1L;

        private Mapping() {
        }
    }
}

