/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.energy;

import com.buuz135.industrial.item.infinity.InfinityEnergyStorage;
import net.roguelogix.phosphophyllite.energy.IPhosphophylliteEnergyStorage;

public class InfinityEnergyStorageWrapper
implements IPhosphophylliteEnergyStorage {
    final InfinityEnergyStorage<?> energyStorage;

    InfinityEnergyStorageWrapper(InfinityEnergyStorage<?> energyStorage) {
        this.energyStorage = energyStorage;
    }

    @Override
    public long insertEnergy(long maxInsert, boolean simulate) {
        if (!this.canInsert()) {
            return 0L;
        }
        long stored = this.energyStorage.getLongEnergyStored();
        long capacity = this.energyStorage.getLongCapacity();
        long toInsert = Math.min(maxInsert, capacity - stored);
        if (!simulate) {
            this.energyStorage.setEnergyStored(stored + toInsert);
        }
        return toInsert;
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long stored = this.energyStorage.getLongEnergyStored();
        long toExtract = Math.min(maxExtract, stored);
        if (!simulate) {
            this.energyStorage.setEnergyStored(stored - toExtract);
        }
        return toExtract;
    }

    @Override
    public long energyStored() {
        return this.energyStorage.getLongEnergyStored();
    }

    @Override
    public long maxEnergyStored() {
        return this.energyStorage.getLongCapacity();
    }

    @Override
    public boolean canInsert() {
        return this.energyStorage.canReceive();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }
}

