/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.blocks.whiteholes;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.roguelogix.phosphophyllite.energy.EnergyStorageWrapper;
import net.roguelogix.phosphophyllite.energy.IPhosphophylliteEnergyStorage;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.registry.TileSupplier;

@RegisterTileEntity(name="power_white_hole")
public class PowerWhiteHoleTile
extends TileEntity
implements IEnergyStorage,
ITickableTileEntity {
    @RegisterTileEntity.Type
    public static TileEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final TileSupplier SUPPLIER;
    private final IEnergyStorage[] lastCapability = new IEnergyStorage[6];
    private final IPhosphophylliteEnergyStorage[] wrapped = new IPhosphophylliteEnergyStorage[6];

    public PowerWhiteHoleTile() {
        super(TYPE);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }

    public void func_73660_a() {
        assert (this.field_145850_b != null);
        for (Direction direction : Direction.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (te == null) continue;
            te.getCapability(CapabilityEnergy.ENERGY, direction.func_176734_d()).ifPresent(c -> {
                int directionIndex = direction.func_176745_a();
                if (c != this.lastCapability[directionIndex]) {
                    this.lastCapability[directionIndex] = c;
                    this.wrapped[directionIndex] = EnergyStorageWrapper.wrap(c);
                }
                this.wrapped[directionIndex].insertEnergy(Long.MAX_VALUE, false);
            });
        }
    }

    static {
        SUPPLIER = PowerWhiteHoleTile::new;
    }
}

