/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.blocks.whiteholes;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.registry.TileSupplier;

@RegisterTileEntity(name="fluid_white_hole")
public class FluidWhiteHoleTile
extends TileEntity
implements IFluidHandler,
ITickableTileEntity {
    @RegisterTileEntity.Type
    public static TileEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final TileSupplier SUPPLIER;
    FluidStack fluidStack = FluidStack.EMPTY;

    public FluidWhiteHoleTile() {
        super(TYPE);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.fluidStack;
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getFluid() == this.fluidStack.getFluid()) {
            return resource.copy();
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return new FluidStack(this.fluidStack.getFluid(), maxDrain);
    }

    public void setFluid(Fluid fluid) {
        this.fluidStack = new FluidStack(fluid, Integer.MAX_VALUE);
    }

    public void func_230337_a_(@Nonnull BlockState state, CompoundNBT compound) {
        this.fluidStack = FluidStack.loadFluidStackFromNBT((CompoundNBT)compound.func_74775_l("fluidstack"));
        super.func_230337_a_(state, compound);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("fluidstack", (INBT)this.fluidStack.writeToNBT(new CompoundNBT()));
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        assert (this.field_145850_b != null);
        for (Direction direction : Direction.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (te == null) continue;
            te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d()).ifPresent(c -> c.fill(this.fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE));
        }
    }

    static {
        SUPPLIER = FluidWhiteHoleTile::new;
    }
}

