/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.blocks.blackholes;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.registry.TileSupplier;

@RegisterTileEntity(name="fluid_black_hole")
public class FluidBlackHoleTile
extends TileEntity
implements IFluidHandler {
    @RegisterTileEntity.Type
    public static TileEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final TileSupplier SUPPLIER;

    public FluidBlackHoleTile() {
        super(TYPE);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return resource.getAmount();
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    static {
        SUPPLIER = FluidBlackHoleTile::new;
    }
}

