/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.squiddev.cobalt.LuaBaseString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.lib.StringLib;

public final class LuaString
extends LuaBaseString {
    public static final int RECENT_STRINGS_CACHE_SIZE = 128;
    public static final int RECENT_STRINGS_MAX_LENGTH = 32;
    public final byte[] bytes;
    public final int offset;
    public final int length;
    private int hashCode;

    public static LuaString valueOf(String string) {
        byte[] bytes = new byte[string.length()];
        LuaString.encode(string, bytes, 0);
        return LuaString.valueOf(bytes, 0, bytes.length);
    }

    public static LuaString valueOf(byte[] bytes, int off, int len) {
        if (bytes.length < 32) {
            return Cache.instance.get(new LuaString(bytes, off, len));
        }
        if (len >= bytes.length / 2) {
            return new LuaString(bytes, off, len);
        }
        byte[] b = new byte[len];
        System.arraycopy(bytes, off, b, 0, len);
        LuaString string = new LuaString(b, 0, len);
        return len < 32 ? Cache.instance.get(string) : string;
    }

    public static LuaString valueOf(char[] bytes) {
        int n = bytes.length;
        byte[] b = new byte[n];
        for (int i = 0; i < n; ++i) {
            b[i] = (byte)bytes[i];
        }
        return LuaString.valueOf(b, 0, n);
    }

    public static LuaString valueOf(byte[] bytes) {
        return LuaString.valueOf(bytes, 0, bytes.length);
    }

    private LuaString(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public String toString() {
        return LuaString.decode(this.bytes, this.offset, this.length);
    }

    public int compare(LuaString rhs) {
        int i = 0;
        for (int j = 0; i < this.length && j < rhs.length; ++i, ++j) {
            if (this.bytes[this.offset + i] == rhs.bytes[rhs.offset + j]) continue;
            return (this.bytes[this.offset + i] & 0xFF) - (rhs.bytes[rhs.offset + j] & 0xFF);
        }
        return this.length - rhs.length;
    }

    @Override
    public LuaString strvalue() {
        return this;
    }

    public LuaString substring(int beginIndex, int endIndex) {
        return LuaString.valueOf(this.bytes, this.offset + beginIndex, endIndex - beginIndex);
    }

    public LuaString substring(int beginIndex) {
        return LuaString.valueOf(this.bytes, this.offset + beginIndex, this.length - 1);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h != 0) {
            return h;
        }
        h = this.length;
        int step = (this.length >> 5) + 1;
        for (int l1 = this.length; l1 >= step; l1 -= step) {
            h ^= (h << 5) + (h >> 2) + (this.bytes[this.offset + l1 - 1] & 0xFF);
        }
        this.hashCode = h;
        return h;
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof LuaValue && ((LuaValue)o).raweq(this);
    }

    @Override
    public boolean raweq(LuaValue val) {
        return val.raweq(this);
    }

    @Override
    public boolean raweq(LuaString s) {
        if (this == s) {
            return true;
        }
        if (s.length != this.length) {
            return false;
        }
        if (s.bytes == this.bytes && s.offset == this.offset) {
            return true;
        }
        if (s.hashCode() != this.hashCode()) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (s.bytes[s.offset + i] == this.bytes[this.offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(LuaString a, int i, LuaString b, int j, int n) {
        return LuaString.equals(a.bytes, a.offset + i, b.bytes, b.offset + j, n);
    }

    public static boolean equals(byte[] a, int i, byte[] b, int j, int n) {
        if (a.length < i + n || b.length < j + n) {
            return false;
        }
        while (--n >= 0) {
            if (a[i++] == b[j++]) continue;
            return false;
        }
        return true;
    }

    public void write(DataOutputStream writer, int i, int len) throws IOException {
        writer.write(this.bytes, this.offset + i, len);
    }

    @Override
    public int length() {
        return this.length;
    }

    public int luaByte(int index) {
        return this.bytes[this.offset + index] & 0xFF;
    }

    public boolean startsWith(int character) {
        return this.length != 0 && this.luaByte(0) == character;
    }

    public int charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.luaByte(index);
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.bytes, this.offset, this.length);
    }

    public int copyTo(int strOffset, byte[] bytes, int arrayOffset, int len) {
        System.arraycopy(this.bytes, this.offset + strOffset, bytes, arrayOffset, len);
        return arrayOffset + len;
    }

    public int copyTo(byte[] bytes, int arrayOffset) {
        return this.copyTo(0, bytes, arrayOffset, this.length);
    }

    public int indexOfAny(LuaString accept) {
        int ilimit = this.offset + this.length;
        int jlimit = accept.offset + accept.length;
        for (int i = this.offset; i < ilimit; ++i) {
            for (int j = accept.offset; j < jlimit; ++j) {
                if (this.bytes[i] != accept.bytes[j]) continue;
                return i - this.offset;
            }
        }
        return -1;
    }

    public int indexOf(byte b, int start) {
        int j = this.offset + start;
        for (int i = 0; i < this.length; ++i) {
            if (this.bytes[j++] != b) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(LuaString s, int start) {
        int slen = s.length();
        int limit = this.offset + this.length - slen;
        for (int i = this.offset + start; i <= limit; ++i) {
            if (!LuaString.equals(this.bytes, i, s.bytes, s.offset, slen)) continue;
            return i - this.offset;
        }
        return -1;
    }

    public int lastIndexOf(LuaString s) {
        int limit;
        int slen = s.length();
        for (int i = limit = this.offset + this.length - slen; i >= this.offset; --i) {
            if (!LuaString.equals(this.bytes, i, s.bytes, s.offset, slen)) continue;
            return i;
        }
        return -1;
    }

    public static String decode(byte[] bytes, int offset, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(bytes[offset + i] & 0xFF);
        }
        return String.valueOf(chars);
    }

    public static void encode(String string, byte[] bytes, int off) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            bytes[i + off] = c < '\u0100' ? (int)c : 63;
        }
    }

    public static void encode(char[] string, byte[] bytes, int off) {
        for (int i = 0; i < string.length; ++i) {
            char c = string[i];
            bytes[i + off] = c < '\u0100' ? (int)c : 63;
        }
    }

    public static LuaString valueOfUtf8(String string) {
        byte[] b = new byte[LuaString.lengthAsUtf8(string)];
        LuaString.encodeToUtf8(string, b, 0);
        return LuaString.valueOf(b, 0, b.length);
    }

    public String toUtf8() {
        return LuaString.decodeAsUtf8(this.bytes, this.offset, this.length);
    }

    public static String decodeAsUtf8(byte[] bytes, int offset, int length) {
        int i = offset;
        int j = offset + length;
        int n = 0;
        while (i < j) {
            switch (0xE0 & bytes[i++]) {
                case 224: {
                    ++i;
                }
                case 192: {
                    ++i;
                }
            }
            ++n;
        }
        char[] chars = new char[n];
        i = offset;
        j = offset + length;
        n = 0;
        while (i < j) {
            int b;
            chars[n++] = (char)((b = bytes[i++]) >= 0 || i >= j ? b : (b < -32 || i + 1 >= j ? (b & 0x3F) << 6 | bytes[i++] & 0x3F : (b & 0xF) << 12 | (bytes[i++] & 0x3F) << 6 | bytes[i++] & 0x3F));
        }
        return new String(chars);
    }

    public static int lengthAsUtf8(String chars) {
        int b;
        int i = b = chars.length();
        while (--i >= 0) {
            char c = chars.charAt(i);
            if (c < '\u0080') continue;
            b += c >= '\u0800' ? 2 : 1;
        }
        return b;
    }

    public static void encodeToUtf8(String chars, byte[] bytes, int off) {
        int n = chars.length();
        int j = off;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c < '\u0080') {
                bytes[j++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                bytes[j++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytes[j++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            bytes[j++] = (byte)(0xE0 | c >> 12 & 0xF);
            bytes[j++] = (byte)(0x80 | c >> 6 & 0x3F);
            bytes[j++] = (byte)(0x80 | c & 0x3F);
        }
    }

    public boolean isValidUtf8() {
        boolean e = false;
        int i = this.offset;
        int j = this.offset + this.length;
        int n = 0;
        while (i < j) {
            byte c;
            if (!((c = this.bytes[i++]) >= 0 || (c & 0xE0) == 192 && i < j && (this.bytes[i++] & 0xC0) == 128 || (c & 0xF0) == 224 && i + 1 < j && (this.bytes[i++] & 0xC0) == 128 && (this.bytes[i++] & 0xC0) == 128)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public double scanNumber(int base) {
        double l;
        boolean isNeg;
        int i;
        if (base < 2 || base > 36) {
            return Double.NaN;
        }
        int j = this.offset + this.length;
        for (i = this.offset; i < j && StringLib.isWhitespace(this.bytes[i]); ++i) {
        }
        while (i < j && StringLib.isWhitespace(this.bytes[j - 1])) {
            --j;
        }
        boolean bl = isNeg = i < j && this.bytes[i] == 45;
        if (isNeg) {
            ++i;
        }
        if (i >= j) {
            return Double.NaN;
        }
        if (!(base != 10 && base != 16 || this.bytes[i] != 48 || i + 1 >= j || this.bytes[i + 1] != 120 && this.bytes[i + 1] != 88)) {
            base = 16;
            i += 2;
        }
        double value = Double.isNaN(l = this.scanLong(base, i, j)) && base == 10 ? this.scandouble(i, j) : l;
        return isNeg ? -value : value;
    }

    private double scanLong(int base, int start, int end) {
        int i;
        long x = 0L;
        boolean neg = this.bytes[start] == 45;
        int n = i = neg ? start + 1 : start;
        while (i < end) {
            int digit = this.bytes[i] - (base <= 10 || this.bytes[i] >= 48 && this.bytes[i] <= 57 ? 48 : (this.bytes[i] >= 65 && this.bytes[i] <= 90 ? 55 : 87));
            if (digit < 0 || digit >= base) {
                return Double.NaN;
            }
            x = x * (long)base + (long)digit;
            ++i;
        }
        return neg ? (double)(-x) : (double)x;
    }

    private double scandouble(int start, int end) {
        if (end > start + 64) {
            end = start + 64;
        }
        block5: for (int i = start; i < end; ++i) {
            switch (this.bytes[i]) {
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 69: 
                case 101: {
                    continue block5;
                }
                default: {
                    return Double.NaN;
                }
            }
        }
        char[] c = new char[end - start];
        for (int i = start; i < end; ++i) {
            c[i - start] = (char)this.bytes[i];
        }
        try {
            return Double.parseDouble(String.valueOf(c));
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    private static class Cache {
        public final LuaString[] recentShortStrings = new LuaString[128];
        public static final Cache instance = new Cache();

        private Cache() {
        }

        public LuaString get(LuaString s) {
            int index = s.hashCode() & 0x7F;
            LuaString cached = this.recentShortStrings[index];
            if (cached != null && s.raweq(cached)) {
                return cached;
            }
            this.recentShortStrings[index] = s;
            return s;
        }
    }
}

