/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaBaseString;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;

public final class LuaRope
extends LuaBaseString {
    private static final int SMALL_STRING = 32;
    private LuaString string;
    private LuaBaseString[] contents;
    private final int length;
    private LuaRope parent;
    private int index;

    private LuaRope(LuaBaseString[] contents, int length) {
        this.contents = contents;
        this.length = length;
    }

    public static LuaBaseString valueOf(LuaValue[] contents, int start, int length, int strLength) {
        if (length == 0 || strLength == 0) {
            return Constants.EMPTYSTRING;
        }
        if (length == 1) {
            return (LuaBaseString)contents[0];
        }
        if (strLength > 32) {
            LuaBaseString[] slice = new LuaBaseString[length];
            System.arraycopy(contents, start, slice, 0, length);
            return new LuaRope(slice, strLength);
        }
        byte[] out = new byte[strLength];
        int position = 0;
        for (int i = 0; i < length; ++i) {
            LuaString string = (LuaString)contents[start + i];
            System.arraycopy(string.bytes, string.offset, out, position, string.length);
            position += string.length;
        }
        return LuaString.valueOf(out);
    }

    @Override
    public LuaString strvalue() {
        return this.string != null ? this.string : LuaRope.actualise(this);
    }

    private static LuaString actualise(LuaRope current) {
        byte[] out = new byte[current.length];
        int position = 0;
        block0: while (true) {
            LuaBaseString[] contents = current.contents;
            for (int index = current.index; index < contents.length; ++index) {
                LuaString string;
                LuaBaseString str = contents[index];
                if (str instanceof LuaRope) {
                    LuaRope rope = (LuaRope)str;
                    if (rope.contents != null) {
                        current.index = index + 1;
                        rope.parent = current;
                        current = rope;
                        continue block0;
                    }
                    string = rope.string;
                } else {
                    string = (LuaString)str;
                }
                System.arraycopy(string.bytes, string.offset, out, position, string.length);
                position += string.length;
            }
            current.index = 0;
            LuaRope parent = current.parent;
            if (parent == null) break;
            current.parent = null;
            current = parent;
        }
        current.contents = null;
        current.string = LuaString.valueOf(out);
        return current.string;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double scanNumber(int base) {
        return this.string.scanNumber(base);
    }

    @Override
    public String toString() {
        return this.strvalue().toString();
    }

    public int hashCode() {
        return this.strvalue().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof LuaValue && ((LuaValue)o).raweq(this.strvalue());
    }

    @Override
    public boolean raweq(LuaValue val) {
        return val.raweq(this.strvalue());
    }

    @Override
    public boolean raweq(LuaString val) {
        return this.strvalue().raweq(val);
    }
}

