/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.event.TurtleInventoryEvent;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;

public class TurtleSuckCommand
implements ITurtleCommand {
    private final InteractDirection direction;
    private final int quantity;

    public TurtleSuckCommand(InteractDirection direction, int quantity) {
        this.direction = direction;
        this.quantity = quantity;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        if (this.quantity == 0) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        Direction direction = this.direction.toWorldDir(turtle);
        World world = turtle.getWorld();
        BlockPos turtlePosition = turtle.getPosition();
        BlockPos blockPosition = turtlePosition.func_177972_a(direction);
        Direction side = direction.func_176734_d();
        IItemHandler inventory = InventoryUtil.getInventory(world, blockPosition, side);
        TurtlePlayer player = TurtlePlayer.getWithPosition(turtle, turtlePosition, direction);
        TurtleInventoryEvent.Suck event = new TurtleInventoryEvent.Suck(turtle, player, world, blockPosition, inventory);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return TurtleCommandResult.failure(event.getFailureMessage());
        }
        if (inventory != null) {
            ItemStack stack = InventoryUtil.takeItems(this.quantity, inventory);
            if (stack.func_190926_b()) {
                return TurtleCommandResult.failure("No items to take");
            }
            ItemStack remainder = InventoryUtil.storeItems(stack, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
            if (!remainder.func_190926_b()) {
                InventoryUtil.storeItems(remainder, inventory);
            }
            if (remainder != stack) {
                turtle.playAnimation(TurtleAnimation.WAIT);
                return TurtleCommandResult.success();
            }
            return TurtleCommandResult.failure("No space for items");
        }
        AxisAlignedBB aabb = new AxisAlignedBB((double)blockPosition.func_177958_n(), (double)blockPosition.func_177956_o(), (double)blockPosition.func_177952_p(), (double)blockPosition.func_177958_n() + 1.0, (double)blockPosition.func_177956_o() + 1.0, (double)blockPosition.func_177952_p() + 1.0);
        List list = world.func_175647_a(ItemEntity.class, aabb, EntityPredicates.field_94557_a);
        if (list.isEmpty()) {
            return TurtleCommandResult.failure("No items to take");
        }
        for (ItemEntity entity : list) {
            ItemStack remainder;
            ItemStack leaveStack;
            ItemStack storeStack;
            ItemStack stack = entity.func_92059_d().func_77946_l();
            if (stack.func_190916_E() > this.quantity) {
                storeStack = stack.func_77979_a(this.quantity);
                leaveStack = stack;
            } else {
                storeStack = stack;
                leaveStack = ItemStack.field_190927_a;
            }
            if ((remainder = InventoryUtil.storeItems(storeStack, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot())) == storeStack) continue;
            if (remainder.func_190926_b() && leaveStack.func_190926_b()) {
                entity.func_70106_y();
            } else if (remainder.func_190926_b()) {
                entity.func_92058_a(leaveStack);
            } else if (leaveStack.func_190926_b()) {
                entity.func_92058_a(remainder);
            } else {
                leaveStack.func_190917_f(remainder.func_190916_E());
                entity.func_92058_a(leaveStack);
            }
            world.func_175669_a(1000, turtlePosition, 0);
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure("No space for items");
    }
}

