/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.apis;

import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class PocketAPI
implements ILuaAPI {
    private final PocketServerComputer computer;

    public PocketAPI(PocketServerComputer computer) {
        this.computer = computer;
    }

    @Override
    public String[] getNames() {
        return new String[]{"pocket"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] equipBack() {
        ItemStack stack;
        Entity entity = this.computer.getEntity();
        if (!(entity instanceof PlayerEntity)) {
            return new Object[]{false, "Cannot find player"};
        }
        PlayerEntity player = (PlayerEntity)entity;
        PlayerInventory inventory = player.field_71071_by;
        IPocketUpgrade previousUpgrade = this.computer.getUpgrade();
        IPocketUpgrade newUpgrade = PocketAPI.findUpgrade((NonNullList<ItemStack>)inventory.field_70462_a, inventory.field_70461_c, previousUpgrade);
        if (newUpgrade == null) {
            newUpgrade = PocketAPI.findUpgrade((NonNullList<ItemStack>)inventory.field_184439_c, 0, previousUpgrade);
        }
        if (newUpgrade == null) {
            return new Object[]{false, "Cannot find a valid upgrade"};
        }
        if (previousUpgrade != null && !(stack = previousUpgrade.getCraftingItem()).func_190926_b() && !(stack = InventoryUtil.storeItems(stack, (IItemHandler)new PlayerMainInvWrapper(inventory), inventory.field_70461_c)).func_190926_b()) {
            WorldUtil.dropItemStack(stack, player.func_130014_f_(), player.func_213303_ch());
        }
        this.computer.setUpgrade(newUpgrade);
        return new Object[]{true};
    }

    @LuaFunction(mainThread=true)
    public final Object[] unequipBack() {
        Entity entity = this.computer.getEntity();
        if (!(entity instanceof PlayerEntity)) {
            return new Object[]{false, "Cannot find player"};
        }
        PlayerEntity player = (PlayerEntity)entity;
        PlayerInventory inventory = player.field_71071_by;
        IPocketUpgrade previousUpgrade = this.computer.getUpgrade();
        if (previousUpgrade == null) {
            return new Object[]{false, "Nothing to unequip"};
        }
        this.computer.setUpgrade(null);
        ItemStack stack = previousUpgrade.getCraftingItem();
        if (!stack.func_190926_b() && (stack = InventoryUtil.storeItems(stack, (IItemHandler)new PlayerMainInvWrapper(inventory), inventory.field_70461_c)).func_190926_b()) {
            WorldUtil.dropItemStack(stack, player.func_130014_f_(), player.func_213303_ch());
        }
        return new Object[]{true};
    }

    private static IPocketUpgrade findUpgrade(NonNullList<ItemStack> inv, int start, IPocketUpgrade previous) {
        for (int i = 0; i < inv.size(); ++i) {
            IPocketUpgrade newUpgrade;
            ItemStack invStack = (ItemStack)inv.get((i + start) % inv.size());
            if (invStack.func_190926_b() || (newUpgrade = PocketUpgrades.get(invStack)) == null || newUpgrade == previous) continue;
            invStack = invStack.func_77946_l();
            invStack.func_190918_g(1);
            inv.set((i + start) % inv.size(), (Object)(invStack.func_190926_b() ? ItemStack.field_190927_a : invStack));
            return newUpgrade;
        }
        return null;
    }
}

