/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.shared.common.BlockGeneric;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.RegistryObject;

public class BlockMonitor
extends BlockGeneric {
    public static final DirectionProperty ORIENTATION = DirectionProperty.func_196962_a((String)"orientation", (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<MonitorEdgeState> STATE = EnumProperty.func_177709_a((String)"state", MonitorEdgeState.class);

    public BlockMonitor(AbstractBlock.Properties settings, RegistryObject<? extends TileEntityType<? extends TileMonitor>> type) {
        super(settings, type);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)ORIENTATION, (Comparable)Direction.NORTH)).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(STATE, (Comparable)((Object)MonitorEdgeState.NONE)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ORIENTATION, FACING, STATE});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        float pitch;
        float f = pitch = context.func_195999_j() == null ? 0.0f : context.func_195999_j().field_70125_A;
        Direction orientation = pitch > 66.5f ? Direction.UP : (pitch < -66.5f ? Direction.DOWN : Direction.NORTH);
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)ORIENTATION, (Comparable)orientation);
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState blockState, @Nullable LivingEntity livingEntity, @Nonnull ItemStack itemStack) {
        super.func_180633_a(world, pos, blockState, livingEntity, itemStack);
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileMonitor && !world.field_72995_K) {
            TileMonitor monitor = (TileMonitor)entity;
            if (livingEntity == null || livingEntity instanceof FakePlayer) {
                monitor.updateNeighborsDeferred();
                return;
            }
            monitor.expand();
        }
    }
}

