/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import dan200.computercraft.shared.media.items.ItemDisk;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.ColourTracker;
import dan200.computercraft.shared.util.ColourUtils;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class DiskRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<DiskRecipe> SERIALIZER = new SpecialRecipeSerializer(DiskRecipe::new);

    public DiskRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        boolean paperFound = false;
        boolean redstoneFound = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == Items.field_151121_aF) {
                if (paperFound) {
                    return false;
                }
                paperFound = true;
                continue;
            }
            if (Tags.Items.DUSTS_REDSTONE.func_230235_a_((Object)stack.func_77973_b())) {
                if (redstoneFound) {
                    return false;
                }
                redstoneFound = true;
                continue;
            }
            if (ColourUtils.getStackColour(stack) != null) continue;
            return false;
        }
        return redstoneFound && paperFound;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInventory inv) {
        ColourTracker tracker = new ColourTracker();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            DyeColor dye;
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() == Items.field_151121_aF || Tags.Items.DUSTS_REDSTONE.func_230235_a_((Object)stack.func_77973_b()) || (dye = ColourUtils.getStackColour(stack)) == null) continue;
            tracker.addColour(dye);
        }
        return ItemDisk.createFromIDAndColour(-1, null, tracker.hasColour() ? tracker.getColour() : Colour.BLUE.getHex());
    }

    public boolean func_194133_a(int x, int y) {
        return x >= 2 && y >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemDisk.createFromIDAndColour(-1, null, Colour.BLUE.getHex());
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

