/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration.crafttweaker.actions;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.logger.ILogger;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.shared.TurtleUpgrades;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;

public class RemoveTurtleUpgradeByItem
implements IUndoableAction {
    private final ItemStack stack;
    private ITurtleUpgrade upgrade;

    public RemoveTurtleUpgradeByItem(ItemStack stack) {
        this.stack = stack;
    }

    public void apply() {
        this.upgrade = TurtleUpgrades.get(this.stack);
        ITurtleUpgrade upgrade = this.upgrade;
        if (upgrade != null) {
            TurtleUpgrades.disable(upgrade);
        }
    }

    public String describe() {
        return String.format("Remove turtle upgrades crafted with '%s'", this.stack);
    }

    public void undo() {
        if (this.upgrade != null) {
            TurtleUpgrades.enable(this.upgrade);
        }
    }

    public String describeUndo() {
        return String.format("Adding back turtle upgrades crafted with '%s'", this.stack);
    }

    public boolean validate(ILogger logger) {
        if (TurtleUpgrades.get(this.stack) == null) {
            logger.error(String.format("Unknown turtle upgrade crafted with '%s'.", this.stack));
            return false;
        }
        return true;
    }

    public boolean shouldApplyOn(LogicalSide side) {
        return true;
    }
}

