/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.Palette;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;

public final class FixedWidthFontRenderer {
    private static final Matrix4f IDENTITY = TransformationMatrix.func_227983_a_().func_227988_c_();
    private static final ResourceLocation FONT = new ResourceLocation("computercraft", "textures/gui/term_font.png");
    public static final int FONT_HEIGHT = 9;
    public static final int FONT_WIDTH = 6;
    public static final float WIDTH = 256.0f;
    public static final float BACKGROUND_START = 0.9765625f;
    public static final float BACKGROUND_END = 0.984375f;
    public static final RenderType TYPE = Type.MAIN;

    private FixedWidthFontRenderer() {
    }

    public static float toGreyscale(double[] rgb) {
        return (float)((rgb[0] + rgb[1] + rgb[2]) / 3.0);
    }

    public static int getColour(char c, Colour def) {
        return 15 - Terminal.getColour(c, def);
    }

    private static void drawChar(Matrix4f transform, IVertexBuilder buffer, float x, float y, int index, float r, float g, float b) {
        if (index == 0 || index == 32) {
            return;
        }
        int column = index % 16;
        int row = index / 16;
        int xStart = 1 + column * 8;
        int yStart = 1 + row * 11;
        buffer.func_227888_a_(transform, x, y, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_((float)xStart / 256.0f, (float)yStart / 256.0f).func_181675_d();
        buffer.func_227888_a_(transform, x, y + 9.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_((float)xStart / 256.0f, (float)(yStart + 9) / 256.0f).func_181675_d();
        buffer.func_227888_a_(transform, x + 6.0f, y, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_((float)(xStart + 6) / 256.0f, (float)yStart / 256.0f).func_181675_d();
        buffer.func_227888_a_(transform, x + 6.0f, y, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_((float)(xStart + 6) / 256.0f, (float)yStart / 256.0f).func_181675_d();
        buffer.func_227888_a_(transform, x, y + 9.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_((float)xStart / 256.0f, (float)(yStart + 9) / 256.0f).func_181675_d();
        buffer.func_227888_a_(transform, x + 6.0f, y + 9.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_((float)(xStart + 6) / 256.0f, (float)(yStart + 9) / 256.0f).func_181675_d();
    }

    private static void drawQuad(Matrix4f transform, IVertexBuilder buffer, float x, float y, float width, float height, float r, float g, float b) {
        buffer.func_227888_a_(transform, x, y, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.9765625f, 0.9765625f).func_181675_d();
        buffer.func_227888_a_(transform, x, y + height, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.9765625f, 0.984375f).func_181675_d();
        buffer.func_227888_a_(transform, x + width, y, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.984375f, 0.9765625f).func_181675_d();
        buffer.func_227888_a_(transform, x + width, y, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.984375f, 0.9765625f).func_181675_d();
        buffer.func_227888_a_(transform, x, y + height, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.9765625f, 0.984375f).func_181675_d();
        buffer.func_227888_a_(transform, x + width, y + height, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.984375f, 0.984375f).func_181675_d();
    }

    private static void drawQuad(Matrix4f transform, IVertexBuilder buffer, float x, float y, float width, float height, Palette palette, boolean greyscale, char colourIndex) {
        float r;
        float g;
        float b;
        double[] colour = palette.getColour(FixedWidthFontRenderer.getColour(colourIndex, Colour.BLACK));
        if (greyscale) {
            g = b = FixedWidthFontRenderer.toGreyscale(colour);
            r = b;
        } else {
            r = (float)colour[0];
            g = (float)colour[1];
            b = (float)colour[2];
        }
        FixedWidthFontRenderer.drawQuad(transform, buffer, x, y, width, height, r, g, b);
    }

    private static void drawBackground(@Nonnull Matrix4f transform, @Nonnull IVertexBuilder renderer, float x, float y, @Nonnull TextBuffer backgroundColour, @Nonnull Palette palette, boolean greyscale, float leftMarginSize, float rightMarginSize, float height) {
        if (leftMarginSize > 0.0f) {
            FixedWidthFontRenderer.drawQuad(transform, renderer, x - leftMarginSize, y, leftMarginSize, height, palette, greyscale, backgroundColour.charAt(0));
        }
        if (rightMarginSize > 0.0f) {
            FixedWidthFontRenderer.drawQuad(transform, renderer, x + (float)(backgroundColour.length() * 6), y, rightMarginSize, height, palette, greyscale, backgroundColour.charAt(backgroundColour.length() - 1));
        }
        int blockStart = 0;
        char blockColour = '\u0000';
        for (int i = 0; i < backgroundColour.length(); ++i) {
            char colourIndex = backgroundColour.charAt(i);
            if (colourIndex == blockColour) continue;
            if (blockColour != '\u0000') {
                FixedWidthFontRenderer.drawQuad(transform, renderer, x + (float)(blockStart * 6), y, (float)(6 * (i - blockStart)), height, palette, greyscale, blockColour);
            }
            blockColour = colourIndex;
            blockStart = i;
        }
        if (blockColour != '\u0000') {
            FixedWidthFontRenderer.drawQuad(transform, renderer, x + (float)(blockStart * 6), y, (float)(6 * (backgroundColour.length() - blockStart)), height, palette, greyscale, blockColour);
        }
    }

    public static void drawString(@Nonnull Matrix4f transform, @Nonnull IVertexBuilder renderer, float x, float y, @Nonnull TextBuffer text, @Nonnull TextBuffer textColour, @Nullable TextBuffer backgroundColour, @Nonnull Palette palette, boolean greyscale, float leftMarginSize, float rightMarginSize) {
        if (backgroundColour != null) {
            FixedWidthFontRenderer.drawBackground(transform, renderer, x, y, backgroundColour, palette, greyscale, leftMarginSize, rightMarginSize, 9.0f);
        }
        for (int i = 0; i < text.length(); ++i) {
            float r;
            float g;
            float b;
            double[] colour = palette.getColour(FixedWidthFontRenderer.getColour(textColour.charAt(i), Colour.BLACK));
            if (greyscale) {
                g = b = FixedWidthFontRenderer.toGreyscale(colour);
                r = b;
            } else {
                r = (float)colour[0];
                g = (float)colour[1];
                b = (float)colour[2];
            }
            int index = text.charAt(i);
            if (index > 255) {
                index = 63;
            }
            FixedWidthFontRenderer.drawChar(transform, renderer, x + (float)(i * 6), y, index, r, g, b);
        }
    }

    public static void drawString(float x, float y, @Nonnull TextBuffer text, @Nonnull TextBuffer textColour, @Nullable TextBuffer backgroundColour, @Nonnull Palette palette, boolean greyscale, float leftMarginSize, float rightMarginSize) {
        FixedWidthFontRenderer.bindFont();
        IRenderTypeBuffer.Impl renderer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        FixedWidthFontRenderer.drawString(IDENTITY, renderer.getBuffer(TYPE), x, y, text, textColour, backgroundColour, palette, greyscale, leftMarginSize, rightMarginSize);
        renderer.func_228461_a_();
    }

    public static void drawTerminalWithoutCursor(@Nonnull Matrix4f transform, @Nonnull IVertexBuilder buffer, float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        Palette palette = terminal.getPalette();
        int height = terminal.getHeight();
        FixedWidthFontRenderer.drawBackground(transform, buffer, x, y - topMarginSize, terminal.getBackgroundColourLine(0), palette, greyscale, leftMarginSize, rightMarginSize, topMarginSize);
        FixedWidthFontRenderer.drawBackground(transform, buffer, x, y + (float)(height * 9), terminal.getBackgroundColourLine(height - 1), palette, greyscale, leftMarginSize, rightMarginSize, bottomMarginSize);
        for (int i = 0; i < height; ++i) {
            FixedWidthFontRenderer.drawString(transform, buffer, x, y + (float)(9 * i), terminal.getLine(i), terminal.getTextColourLine(i), terminal.getBackgroundColourLine(i), palette, greyscale, leftMarginSize, rightMarginSize);
        }
    }

    public static void drawCursor(@Nonnull Matrix4f transform, @Nonnull IVertexBuilder buffer, float x, float y, @Nonnull Terminal terminal, boolean greyscale) {
        Palette palette = terminal.getPalette();
        int width = terminal.getWidth();
        int height = terminal.getHeight();
        int cursorX = terminal.getCursorX();
        int cursorY = terminal.getCursorY();
        if (terminal.getCursorBlink() && cursorX >= 0 && cursorX < width && cursorY >= 0 && cursorY < height && FrameInfo.getGlobalCursorBlink()) {
            float r;
            float g;
            float b;
            double[] colour = palette.getColour(15 - terminal.getTextColour());
            if (greyscale) {
                g = b = FixedWidthFontRenderer.toGreyscale(colour);
                r = b;
            } else {
                r = (float)colour[0];
                g = (float)colour[1];
                b = (float)colour[2];
            }
            FixedWidthFontRenderer.drawChar(transform, buffer, x + (float)(cursorX * 6), y + (float)(cursorY * 9), 95, r, g, b);
        }
    }

    public static void drawTerminal(@Nonnull Matrix4f transform, @Nonnull IVertexBuilder buffer, float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        FixedWidthFontRenderer.drawTerminalWithoutCursor(transform, buffer, x, y, terminal, greyscale, topMarginSize, bottomMarginSize, leftMarginSize, rightMarginSize);
        FixedWidthFontRenderer.drawCursor(transform, buffer, x, y, terminal, greyscale);
    }

    public static void drawTerminal(@Nonnull Matrix4f transform, float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        FixedWidthFontRenderer.bindFont();
        IRenderTypeBuffer.Impl renderer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder buffer = renderer.getBuffer(TYPE);
        FixedWidthFontRenderer.drawTerminal(transform, buffer, x, y, terminal, greyscale, topMarginSize, bottomMarginSize, leftMarginSize, rightMarginSize);
        renderer.func_228462_a_(TYPE);
    }

    public static void drawTerminal(float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        FixedWidthFontRenderer.drawTerminal(IDENTITY, x, y, terminal, greyscale, topMarginSize, bottomMarginSize, leftMarginSize, rightMarginSize);
    }

    public static void drawEmptyTerminal(@Nonnull Matrix4f transform, @Nonnull IRenderTypeBuffer renderer, float x, float y, float width, float height) {
        Colour colour = Colour.BLACK;
        FixedWidthFontRenderer.drawQuad(transform, renderer.getBuffer(TYPE), x, y, width, height, colour.getR(), colour.getG(), colour.getB());
    }

    public static void drawEmptyTerminal(@Nonnull Matrix4f transform, float x, float y, float width, float height) {
        FixedWidthFontRenderer.bindFont();
        IRenderTypeBuffer.Impl renderer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        FixedWidthFontRenderer.drawEmptyTerminal(transform, (IRenderTypeBuffer)renderer, x, y, width, height);
        renderer.func_228461_a_();
    }

    public static void drawEmptyTerminal(float x, float y, float width, float height) {
        FixedWidthFontRenderer.drawEmptyTerminal(IDENTITY, x, y, width, height);
    }

    public static void drawBlocker(@Nonnull Matrix4f transform, @Nonnull IRenderTypeBuffer renderer, float x, float y, float width, float height) {
        Colour colour = Colour.BLACK;
        FixedWidthFontRenderer.drawQuad(transform, renderer.getBuffer(Type.BLOCKER), x, y, width, height, colour.getR(), colour.getG(), colour.getB());
    }

    private static void bindFont() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(FONT);
        RenderSystem.texParameter((int)3553, (int)10242, (int)10496);
    }

    static /* synthetic */ ResourceLocation access$000() {
        return FONT;
    }

    private static final class Type
    extends RenderState {
        private static final int GL_MODE = 4;
        private static final VertexFormat FORMAT = DefaultVertexFormats.field_227851_o_;
        static final RenderType MAIN = RenderType.func_228633_a_((String)"terminal_font", (VertexFormat)FORMAT, (int)4, (int)1024, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(FixedWidthFontRenderer.access$000(), false, false)).func_228713_a_(field_228517_i_).func_228719_a_(field_228529_u_).func_228727_a_(field_228496_F_).func_228728_a_(false));
        static final RenderType BLOCKER = RenderType.func_228633_a_((String)"terminal_blocker", (VertexFormat)FORMAT, (int)4, (int)256, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(FixedWidthFontRenderer.access$000(), false, false)).func_228713_a_(field_228517_i_).func_228727_a_(field_228497_G_).func_228719_a_(field_228529_u_).func_228728_a_(false));

        private Type(String name, Runnable setup, Runnable destroy) {
            super(name, setup, destroy);
        }
    }
}

