/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.compat.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import owmii.lib.util.Recipe;
import owmii.powah.block.Blcks;
import owmii.powah.client.compat.jei.CoolantCategory;
import owmii.powah.client.compat.jei.HeatSourceCategory;
import owmii.powah.client.compat.jei.SolidCoolantCategory;
import owmii.powah.client.compat.jei.energizing.EnergizingCategory;
import owmii.powah.client.compat.jei.magmator.MagmatorCategory;
import owmii.powah.config.Configs;
import owmii.powah.item.Itms;
import owmii.powah.recipe.Recipes;

@JeiPlugin
public class PowahJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new MagmatorCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CoolantCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SolidCoolantCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new HeatSourceCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EnergizingCategory(helper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Blcks.ENERGIZING_ORB), new ResourceLocation[]{EnergizingCategory.ID});
        Blcks.ENERGIZING_ROD.getAll().forEach(block -> registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)block), new ResourceLocation[]{EnergizingCategory.ID}));
        Blcks.MAGMATOR.getAll().forEach(block -> registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)block), new ResourceLocation[]{MagmatorCategory.ID}));
        Blcks.THERMO_GENERATOR.getAll().forEach(block -> {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)block), new ResourceLocation[]{HeatSourceCategory.ID});
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)block), new ResourceLocation[]{CoolantCategory.ID});
        });
        Blcks.REACTOR.getAll().forEach(block -> {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)block), new ResourceLocation[]{SolidCoolantCategory.ID});
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)block), new ResourceLocation[]{CoolantCategory.ID});
        });
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(Recipe.getAll((World)Minecraft.func_71410_x().field_71441_e, Recipes.ENERGIZING), EnergizingCategory.ID);
        registration.addRecipes(MagmatorCategory.Maker.getBucketRecipes(registration.getIngredientManager()), MagmatorCategory.ID);
        registration.addRecipes(CoolantCategory.Maker.getBucketRecipes(registration.getIngredientManager()), CoolantCategory.ID);
        registration.addRecipes(SolidCoolantCategory.Maker.getBucketRecipes(registration.getIngredientManager()), SolidCoolantCategory.ID);
        registration.addRecipes(HeatSourceCategory.Maker.getBucketRecipes(registration.getIngredientManager()), HeatSourceCategory.ID);
        if (((Boolean)Configs.GENERAL.player_aerial_pearl.get()).booleanValue()) {
            registration.addIngredientInfo((Object)new ItemStack((IItemProvider)Itms.PLAYER_AERIAL_PEARL), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.powah.player_aerial_pearl", (Object[])new Object[0])});
        }
        if (((Boolean)Configs.GENERAL.binding_card_dim.get()).booleanValue()) {
            registration.addIngredientInfo((Object)new ItemStack((IItemProvider)Itms.BINDING_CARD_DIM), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.powah.binding_card_dim", (Object[])new Object[0])});
        }
        if (((Boolean)Configs.GENERAL.lens_of_ender.get()).booleanValue()) {
            registration.addIngredientInfo((Object)new ItemStack((IItemProvider)Itms.LENS_OF_ENDER), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.powah.lens_of_ender", (Object[])new Object[0])});
        }
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("powah", "main");
    }
}

