/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import owmii.powah.Powah;
import owmii.powah.api.PowahAPI;

public class HeatSourceCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("powah", "textures/gui/jei/misc.png");
    public static final ResourceLocation ID = new ResourceLocation("powah", "heat.sources");
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public HeatSourceCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 24).addPadding(1, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Blocks.field_196814_hQ));
        this.localizedName = I18n.func_135052_a((String)"gui.powah.jei.category.heat.sources", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        if (recipe.fluid == null) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)recipe.getBlock()));
        } else {
            ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack(recipe.fluid, 1000));
        }
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients ingredients) {
        if (recipe.fluid == null) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 3, 4);
            itemStacks.set(ingredients);
        } else {
            IGuiFluidStackGroup fluidStack = iRecipeLayout.getFluidStacks();
            fluidStack.init(0, true, 4, 5);
            fluidStack.set(ingredients);
        }
    }

    public void draw(Recipe recipe, MatrixStack matrix, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71466_p.func_238421_b_(matrix, TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"info.lollipop.temperature", (Object[])new Object[0]) + ": " + TextFormatting.RESET + I18n.func_135052_a((String)"info.lollipop.temperature.c", (Object[])new Object[]{recipe.heat}), 30.0f, 9.0f, 12858368);
    }

    public static class Recipe {
        private final Block block;
        private final int heat;
        @Nullable
        private final Fluid fluid;

        public Recipe(Block block, int heat) {
            this.fluid = block instanceof FlowingFluidBlock ? ((FlowingFluidBlock)block).getFluid() : null;
            this.block = block;
            this.heat = heat;
            Powah.LOGGER.debug("HEAT SOURCE RECIPE INIT: " + this);
        }

        @Nullable
        public Fluid getFluid() {
            return this.fluid;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getHeat() {
            return this.heat;
        }

        public String toString() {
            return "HeatSourceRecipe{" + this.block.getRegistryName() + (this.fluid != null ? " (fluid " + this.fluid.getRegistryName() + ")" : "") + " -> " + this.heat + "}";
        }
    }

    public static class Maker {
        public static List<Recipe> getBucketRecipes(IIngredientManager ingredientManager) {
            Collection allItemStacks = ingredientManager.getAllIngredients(VanillaTypes.ITEM);
            ArrayList<Recipe> recipes = new ArrayList<Recipe>();
            Powah.LOGGER.debug("HEAT SOURCE RECIPE ALL: [" + PowahAPI.HEAT_SOURCES.entrySet().stream().map(e -> e.getKey() + " -> " + e.getValue()).collect(Collectors.joining(", ")) + "]");
            allItemStacks.forEach(stack -> {
                BlockItem item;
                Block block;
                if (stack.func_77973_b() instanceof BlockItem && PowahAPI.HEAT_SOURCES.containsKey(block = (item = (BlockItem)stack.func_77973_b()).func_179223_d())) {
                    recipes.add(new Recipe(block, PowahAPI.getHeatSource(block)));
                }
            });
            Collection allIngredients = ingredientManager.getAllIngredients(VanillaTypes.FLUID);
            allIngredients.forEach(fluidStack -> {
                Block block;
                if (!fluidStack.isEmpty() && PowahAPI.HEAT_SOURCES.containsKey(block = fluidStack.getFluid().func_207188_f().func_206883_i().func_177230_c())) {
                    recipes.add(new Recipe(block, PowahAPI.getHeatSource(block)));
                }
            });
            return recipes;
        }
    }
}

