/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.thermo;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import owmii.lib.block.AbstractEnergyProvider;
import owmii.lib.block.IInventoryHolder;
import owmii.lib.block.ITankHolder;
import owmii.lib.logistics.energy.Energy;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.thermo.ThermoBlock;
import owmii.powah.config.generator.ThermoConfig;

public class ThermoTile
extends AbstractEnergyProvider<Tier, ThermoConfig, ThermoBlock>
implements IInventoryHolder,
ITankHolder {
    public long generating;

    public ThermoTile(Tier variant) {
        super(Tiles.THERMO_GEN, (Enum)variant);
        this.tank.setCapacity(4000).validate(stack -> PowahAPI.COOLANTS.containsKey(stack.getFluid())).setChange(() -> this.sync(10));
        this.inv.add(1);
    }

    public ThermoTile() {
        this(Tier.STARTER);
    }

    public void readSync(CompoundNBT nbt) {
        super.readSync(nbt);
        this.generating = nbt.func_74763_f("generating");
    }

    public CompoundNBT writeSync(CompoundNBT nbt) {
        nbt.func_74772_a("generating", this.generating);
        return super.writeSync(nbt);
    }

    protected int postTick(World world) {
        FluidStack fluid;
        boolean flag = this.chargeItems(1) + this.extractFromSides(world) > 0L;
        boolean i = false;
        if (!this.isRemote() && this.checkRedstone() && !this.tank.isEmpty() && PowahAPI.COOLANTS.containsKey((fluid = this.tank.getFluid()).getFluid())) {
            int fluidCooling = PowahAPI.getCoolant(fluid.getFluid());
            BlockPos heatPos = this.field_174879_c.func_177977_b();
            BlockState state = world.func_180495_p(heatPos);
            Block block = state.func_177230_c();
            if (!this.energy.isFull() && PowahAPI.HEAT_SOURCES.containsKey(block)) {
                FlowingFluidBlock fluidBlock;
                int heat = PowahAPI.getHeatSource(block);
                if (block instanceof FlowingFluidBlock && !(fluidBlock = (FlowingFluidBlock)block).func_204507_t(state).func_206889_d()) {
                    int level = (Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b);
                    heat = (int)((float)heat / ((float)level + 1.0f));
                }
                this.generating = (int)((double)heat * (fluidCooling == 1 ? 1.0 : Math.max(1.1, (0.1 + (double)Math.abs(fluidCooling)) * 1.1152)) * (double)this.getGeneration() / 1000.0);
                this.energy.produce(this.generating);
                if (world.func_82737_E() % 40L == 0L) {
                    this.tank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
        return flag || this.generating > 0L ? 5 : -1;
    }

    public boolean keepEnergy() {
        return true;
    }

    public boolean keepFluid() {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean canInsert(int slot, ItemStack stack) {
        return Energy.chargeable((ItemStack)stack);
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }
}

