/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.solar;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import owmii.lib.block.AbstractEnergyProvider;
import owmii.lib.block.IInventoryHolder;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.util.Misc;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.solar.SolarBlock;
import owmii.powah.config.generator.SolarConfig;
import owmii.powah.item.Itms;

public class SolarTile
extends AbstractEnergyProvider<Tier, SolarConfig, SolarBlock>
implements IInventoryHolder {
    public static final String CAN_SEE_SKY = "can_see_sky";
    public static final String HAS_LENS_OF_ENDER = "has_lens_of_ender";
    private boolean canSeeSky;
    private boolean hasLensOfEnder;

    public SolarTile(Tier variant) {
        super(Tiles.SOLAR_PANEL, (Enum)variant);
        this.inv.add(1);
    }

    public SolarTile() {
        this(Tier.STARTER);
    }

    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        this.canSeeSky = compound.func_74767_n(CAN_SEE_SKY);
        this.hasLensOfEnder = compound.func_74767_n(HAS_LENS_OF_ENDER);
    }

    public CompoundNBT writeSync(CompoundNBT compound) {
        compound.func_74757_a(CAN_SEE_SKY, this.canSeeSky);
        compound.func_74757_a(HAS_LENS_OF_ENDER, this.hasLensOfEnder);
        return super.writeSync(compound);
    }

    protected int postTick(World world) {
        boolean flag;
        if (this.isRemote()) {
            return -1;
        }
        boolean bl = flag = this.chargeItems(1) + this.extractFromSides(world) > 0L;
        if (this.checkRedstone()) {
            boolean canSeeSkyNow;
            if (!this.hasLensOfEnder && (long)this.ticks % 40L == 0L && this.canSeeSky != (canSeeSkyNow = Misc.canBlockSeeSky((World)world, (BlockPos)this.field_174879_c.func_177984_a()))) {
                this.canSeeSky = canSeeSkyNow;
                this.sync();
            }
            if (!this.energy.isFull() && (this.canSeeSky || this.hasLensOfEnder) && world.func_72935_r()) {
                this.energy.produce(this.getGeneration());
                flag = true;
            }
        }
        return flag ? 5 : -1;
    }

    public void onRemoved(World world, BlockState state, BlockState newState, boolean isMoving) {
        super.onRemoved(world, state, newState, isMoving);
        if (state.func_177230_c() != newState.func_177230_c() && this.hasLensOfEnder) {
            Block.func_180635_a((World)world, (BlockPos)this.field_174879_c, (ItemStack)new ItemStack((IItemProvider)Itms.LENS_OF_ENDER));
        }
    }

    public boolean canSeeSky() {
        return this.canSeeSky;
    }

    public boolean keepEnergy() {
        return true;
    }

    public boolean isEnergyPresent(@Nullable Direction side) {
        return Direction.DOWN.equals((Object)side);
    }

    public boolean hasLensOfEnder() {
        return this.hasLensOfEnder;
    }

    public void setHasLensOfEnder(boolean hasLensOfEnder) {
        this.hasLensOfEnder = hasLensOfEnder;
        this.sync();
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean canInsert(int slot, ItemStack stack) {
        return Energy.chargeable((ItemStack)stack);
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }
}

