/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import owmii.lib.block.AbstractTileEntity;
import owmii.lib.registry.IVariant;
import owmii.lib.util.NBT;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.reactor.ReactorBlock;
import owmii.powah.block.reactor.ReactorTile;

public class ReactorPartTile
extends AbstractTileEntity<Tier, ReactorBlock> {
    private BlockPos corePos = BlockPos.field_177992_a;
    private boolean extractor;
    private boolean built;

    public ReactorPartTile(Tier variant) {
        super(Tiles.REACTOR_PART, (IVariant)variant);
    }

    public ReactorPartTile() {
        this(Tier.STARTER);
    }

    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        this.built = compound.func_74767_n("built");
        this.extractor = compound.func_74767_n("extractor");
        this.corePos = NBT.readPos((CompoundNBT)compound, (String)"core_pos");
    }

    public CompoundNBT writeSync(CompoundNBT compound) {
        compound.func_74757_a("built", this.built);
        compound.func_74757_a("extractor", this.extractor);
        NBT.writePos((CompoundNBT)compound, (BlockPos)this.corePos, (String)"core_pos");
        return super.writeSync(compound);
    }

    public void demolish(World world) {
        TileEntity tile = world.func_175625_s(this.corePos);
        if (tile instanceof ReactorTile) {
            ReactorTile reactor = (ReactorTile)tile;
            reactor.demolish(world);
        }
    }

    public Optional<ReactorTile> core() {
        TileEntity tile;
        if (this.field_145850_b != null && (tile = this.field_145850_b.func_175625_s(this.corePos)) instanceof ReactorTile) {
            return Optional.of((ReactorTile)tile);
        }
        return Optional.empty();
    }

    public BlockPos getCorePos() {
        return this.corePos;
    }

    public void setCorePos(BlockPos corePos) {
        this.corePos = corePos;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (this.core().isPresent() && (cap != CapabilityEnergy.ENERGY || this.extractor)) {
            return this.core().get().getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public void setExtractor(boolean extractor) {
        this.extractor = extractor;
    }

    public void setBuilt(boolean built) {
        this.built = built;
    }

    public boolean isBuilt() {
        return this.built;
    }
}

